/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.plugin.olapfunctions.timedimension;

import crazydev.iccube.collection.olapiterator.OlapCompactIterator;
import crazydev.iccube.exception.OlapErrorCode;
import crazydev.iccube.olap.component.naming.OlapNameContext;
import crazydev.iccube.olap.entity.level.OlapLevel;
import crazydev.iccube.olap.entity.member.OlapMember;
import crazydev.iccube.olap.entity.scalar.OlapNonScalarEntity;
import crazydev.iccube.olap.entity.set.OlapSetFactory;
import crazydev.iccube.olap.entity.set.OlapTupleSet;
import crazydev.iccube.olap.entity.tuple.OlapTuple;
import crazydev.iccube.olap.eval.execinstr.gf.context.GFContext;
import crazydev.iccube.olap.eval.execinstr.gf.function.GFFunctionArgs;
import crazydev.iccube.olap.eval.filter.dimension.OlapMemberFilter;
import crazydev.iccube.olap.eval.function.OlapFunctionArgs;
import crazydev.iccube.olap.eval.function.mdx.member.OlapMdxTimeNavigationFunction;
import java.io.Serializable;
import java.util.Arrays;

public class OlapDatesItdTimeDimensionFunction
extends OlapMdxTimeNavigationFunction {
    private static final String NAME = "DatesItd";
    private static final OlapFunctionArgs ARGS = new OlapFunctionArgs(1, 2);

    public OlapDatesItdTimeDimensionFunction() {
        super("dtDatesItd", ARGS);
    }

    public OlapNonScalarEntity evalForCluster(GFContext context, GFFunctionArgs args) {
        OlapMember member = args.toMember(context, 0, true, true);
        if (member == null || member.isMdxNull() || member.isAll()) {
            return OlapSetFactory.empty();
        }
        boolean compact = args.toOptionalBoolean(context, 1, true);
        OlapLevel memberLevel = member.getLevel();
        Object[] keyType = memberLevel.getMemberKeyType();
        if (!(keyType == null || keyType.length == 1 && keyType[0].isDateType())) {
            return (OlapNonScalarEntity)args.onFunctionError(context, OlapErrorCode.LEVEL_DATETIME_KEYTYPE_EXPECTED, new Serializable[]{memberLevel.getUniqueName(OlapNameContext.DEFAULT_VALUES), Arrays.toString(keyType)});
        }
        OlapMemberFilter filter = context.getMemberFilter();
        OlapMember rootMember = member.getHierarchy().getAllMember();
        if (rootMember == null && (rootMember = (OlapMember)member.getHierarchy().getFirstLevel().getMembers(filter).getIterator(false).next()) == null) {
            return OlapSetFactory.instance((OlapTuple[])new OlapMember[]{member});
        }
        OlapMember startMember = rootMember.getFirstDescendant(filter, memberLevel);
        if (startMember == null) {
            return OlapSetFactory.instance((OlapTuple[])new OlapMember[]{member});
        }
        OlapTupleSet set = memberLevel.createMemberRange(filter, startMember, member);
        return compact ? OlapCompactIterator.newInstance((OlapTupleSet)set, (boolean)false) : set;
    }
}

