/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.plugin.olapfunctions.timedimension;

import crazydev.iccube.enums.OlapLevelType;
import crazydev.iccube.exception.OlapErrorCode;
import crazydev.iccube.olap.entity.member.OlapMember;
import crazydev.iccube.olap.entity.scalar.OlapDateEntity;
import crazydev.iccube.olap.entity.scalar.OlapDateTimeEntity;
import crazydev.iccube.olap.entity.scalar.OlapScalarEntity;
import crazydev.iccube.olap.eval.exception.IOlapEvaluationExceptionContext;
import crazydev.iccube.olap.eval.execinstr.gf.context.GFContext;
import crazydev.iccube.olap.eval.execinstr.gf.function.GFFunctionArgs;
import crazydev.iccube.olap.eval.function.OlapFunctionArgs;
import crazydev.iccube.olap.eval.function.OlapScalarEntityFunction;
import java.io.Serializable;
import org.joda.time.LocalDate;
import org.joda.time.LocalDateTime;
import org.joda.time.LocalTime;

public class OlapDatesEndPeriodTimeDimensionFunction
extends OlapScalarEntityFunction {
    public static final String NAME = "dtEndPeriod";
    protected static final OlapFunctionArgs ARGS = new OlapFunctionArgs(1);

    public OlapDatesEndPeriodTimeDimensionFunction() {
        super(NAME, ARGS);
    }

    public OlapScalarEntity evalForCluster(GFContext context, GFFunctionArgs args) {
        OlapMember member = args.toMember(context, 0);
        if (member.isMdxNull()) {
            return OlapDatesEndPeriodTimeDimensionFunction.asEmpty();
        }
        OlapLevelType levelType = member.getLevel().getLevelType();
        if (levelType == null) {
            return (OlapScalarEntity)this.onFunctionError((IOlapEvaluationExceptionContext)context, OlapErrorCode.TYPE_MISMATCH, new Serializable[]{"time level", "no level type"});
        }
        Comparable key = member.getKeyValue();
        if (key instanceof LocalDate) {
            LocalDate localDate = (LocalDate)key;
            LocalDate nextDate = levelType.getNextDate(localDate.toLocalDateTime(LocalTime.MIDNIGHT)).toLocalDate();
            return new OlapDateEntity(nextDate);
        }
        if (key instanceof LocalDateTime) {
            LocalDateTime localDate = (LocalDateTime)key;
            return new OlapDateTimeEntity(levelType.getNextDate(localDate));
        }
        return (OlapScalarEntity)this.onFunctionError((IOlapEvaluationExceptionContext)context, OlapErrorCode.TYPE_MISMATCH, new Serializable[]{"Member with a LocalDate/LocalDateTime key", key.getClass().getName()});
    }
}

