/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.plugin.olapfunctions.others;

import crazydev.iccube.olap.entity.OlapEntity;
import crazydev.iccube.olap.entity.option.OlapOption;
import crazydev.iccube.olap.entity.scalar.OlapDoubleVectorEntity;
import crazydev.iccube.olap.entity.scalar.OlapScalarEntity;
import crazydev.iccube.olap.eval.execinstr.gf.context.GFContext;
import crazydev.iccube.olap.eval.execinstr.gf.function.GFFunctionArgs;
import crazydev.iccube.olap.eval.function.OlapFunctionArgs;
import crazydev.iccube.olap.eval.function.OlapFunctionArgumentType;
import crazydev.iccube.olap.eval.function.OlapScalarEntityFunction;
import it.unimi.dsi.fastutil.doubles.DoubleArrayList;

public class OlapVectorNFunction
extends OlapScalarEntityFunction {
    public static final String NAME = "VectorN";
    public static final OlapFunctionArgs ARGS = new OlapFunctionArgs(1, Integer.MAX_VALUE){

        public OlapFunctionArgumentType getType(int pos) {
            return OlapFunctionArgumentType.VALUE;
        }
    };

    public OlapVectorNFunction() {
        super(NAME, ARGS);
    }

    public OlapScalarEntity evalForCluster(GFContext context, GFFunctionArgs args) {
        int size = args.size();
        OlapOption option = args.toOptionalOptionX(context, args.size() - 1, new OlapOption[]{OlapOption.EXCLUDEEMPTY, OlapOption.INCLUDEEMPTY});
        if (option != null) {
            --size;
        }
        boolean includeEmpty = option == null || option == OlapOption.INCLUDEEMPTY;
        DoubleArrayList values = new DoubleArrayList(size);
        for (int idx = 0; idx < size; ++idx) {
            double value;
            OlapEntity entity = args.getNonMissingArgEntity(context, idx, "numeric");
            if (entity.isMdxNull()) {
                if (!includeEmpty) continue;
                value = 0.0;
            } else {
                value = args.toNumericX(context, 1, entity).doubleValue();
            }
            values.add(value);
        }
        return new OlapDoubleVectorEntity(values.toDoubleArray());
    }
}

