/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.plugin.olapfunctions.others;

import crazydev.common.collection.CdCollections;
import crazydev.iccube.olap.entity.OlapEntity;
import crazydev.iccube.olap.entity.scalar.OlapDoubleVectorEntity;
import crazydev.iccube.olap.entity.scalar.OlapNumericEntity;
import crazydev.iccube.olap.entity.scalar.OlapScalarEntity;
import crazydev.iccube.olap.entity.set.OlapTupleSet;
import crazydev.iccube.olap.entity.tuple.OlapTuple;
import crazydev.iccube.olap.eval.execinstr.gf.context.GFContext;
import crazydev.iccube.olap.eval.execinstr.gf.function.GFFunctionArgs;
import crazydev.iccube.olap.eval.function.OlapFunctionArgs;
import crazydev.iccube.olap.eval.function.mdx.numeric.OlapBaseGenericStatisticalFunction;
import crazydev.iccube.olap.eval.function.mdx.numeric.calculators.OlapSetCalculatorOneGenExpression;
import it.unimi.dsi.fastutil.doubles.DoubleArrayList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;

public class OlapVectorFunction
extends OlapBaseGenericStatisticalFunction {
    public static final String NAME = "Vector";
    public static final OlapFunctionArgs ARGS = new OlapFunctionArgs(2, 4){

        public boolean isLambda(int pos) {
            return pos == 1;
        }
    };

    public OlapVectorFunction() {
        super(NAME, ARGS);
    }

    protected OlapSetCalculatorOneGenExpression createCalculator(GFFunctionArgs args, OlapTupleSet set) {
        boolean includeEmpty = this.getIncludeEmpty(args);
        if (set.isUnorder()) {
            return this.withoutKeepingOrder(args, includeEmpty);
        }
        if (includeEmpty) {
            return this.withEmptyKeepingOrder(args);
        }
        return this.withoutEmptyKeepingOrder(args);
    }

    private OlapSetCalculatorOneGenExpression withoutKeepingOrder(final GFFunctionArgs args, final boolean includeEmpty) {
        return new OlapSetCalculatorOneGenExpression(){
            final DoubleArrayList values;
            final /* synthetic */ OlapVectorFunction this$0;
            {
                OlapVectorFunction olapVectorFunction = this$0;
                Objects.requireNonNull(olapVectorFunction);
                this.this$0 = olapVectorFunction;
                this.values = new DoubleArrayList();
            }

            public int stopIterationOrdinal() {
                return -1;
            }

            public void addNull(OlapTuple setTuple, int iTupleOrdinal) {
                if (includeEmpty) {
                    this.values.add(0.0);
                }
            }

            public void addValue(GFContext context, OlapTuple setTuple, int iTupleOrdinal, OlapScalarEntity value) {
                if (value instanceof OlapNumericEntity) {
                    OlapNumericEntity numeric = (OlapNumericEntity)value;
                    this.values.add(numeric.doubleValue());
                } else {
                    this.this$0.onFunctionArgTypeMismatchError(args.getErrorContext(context), 2, "numeric", value.getFriendlyTypeName());
                }
            }

            public boolean isResultEmpty() {
                return this.values.isEmpty();
            }

            public OlapEntity calculate() {
                return new OlapDoubleVectorEntity(this.values.toDoubleArray());
            }
        };
    }

    private OlapSetCalculatorOneGenExpression withEmptyKeepingOrder(final GFFunctionArgs args) {
        return new OlapSetCalculatorOneGenExpression(){
            final DoubleArrayList values;
            final /* synthetic */ OlapVectorFunction this$0;
            {
                OlapVectorFunction olapVectorFunction = this$0;
                Objects.requireNonNull(olapVectorFunction);
                this.this$0 = olapVectorFunction;
                this.values = new DoubleArrayList();
            }

            public int stopIterationOrdinal() {
                return -1;
            }

            public void addNull(OlapTuple setTuple, int iTupleOrdinal) {
                CdCollections.setValue((DoubleArrayList)this.values, (int)(iTupleOrdinal - 1), (double)0.0);
            }

            public void addValue(GFContext context, OlapTuple setTuple, int iTupleOrdinal, OlapScalarEntity value) {
                if (value instanceof OlapNumericEntity) {
                    OlapNumericEntity numeric = (OlapNumericEntity)value;
                    CdCollections.setValue((DoubleArrayList)this.values, (int)(iTupleOrdinal - 1), (double)numeric.doubleValue());
                } else {
                    this.this$0.onFunctionArgTypeMismatchError(args.getErrorContext(context), 2, "numeric", value.getFriendlyTypeName());
                }
            }

            public boolean isResultEmpty() {
                return this.values.isEmpty();
            }

            public OlapEntity calculate() {
                return new OlapDoubleVectorEntity(this.values.toDoubleArray());
            }
        };
    }

    private OlapSetCalculatorOneGenExpression withoutEmptyKeepingOrder(final GFFunctionArgs args) {
        return new OlapSetCalculatorOneGenExpression(){
            ArrayList<MyClass> list;
            final /* synthetic */ OlapVectorFunction this$0;
            {
                OlapVectorFunction olapVectorFunction = this$0;
                Objects.requireNonNull(olapVectorFunction);
                this.this$0 = olapVectorFunction;
                this.list = new ArrayList();
            }

            public int stopIterationOrdinal() {
                return -1;
            }

            public void addNull(OlapTuple setTuple, int iTupleOrdinal) {
            }

            public void addValue(GFContext context, OlapTuple setTuple, int iTupleOrdinal, OlapScalarEntity value) {
                if (value instanceof OlapNumericEntity) {
                    OlapNumericEntity numeric = (OlapNumericEntity)value;
                    this.list.add(new MyClass(this.this$0, iTupleOrdinal, numeric.doubleValue()));
                } else {
                    this.this$0.onFunctionArgTypeMismatchError(args.getErrorContext(context), 2, "numeric", value.getFriendlyTypeName());
                }
            }

            public boolean isResultEmpty() {
                return this.list.isEmpty();
            }

            public OlapEntity calculate() {
                Object[] array = this.list.toArray(new MyClass[this.list.size()]);
                Arrays.sort(array);
                double[] values = new double[this.list.size()];
                for (int i = 0; i < array.length; ++i) {
                    Object myClass = array[i];
                    values[i] = ((MyClass)myClass).value;
                }
                return new OlapDoubleVectorEntity(values);
            }
        };
    }

    private class MyClass
    implements Comparable<MyClass> {
        int ordinal;
        double value;

        public MyClass(OlapVectorFunction olapVectorFunction, int ordinal, double value) {
            Objects.requireNonNull(olapVectorFunction);
            this.ordinal = ordinal;
            this.value = value;
        }

        @Override
        public int compareTo(MyClass o) {
            return Integer.compare(this.ordinal, o.ordinal);
        }
    }
}

