/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.plugin.olapfunctions.others;

import crazydev.iccube.olap.entity.member.OlapMember;
import crazydev.iccube.olap.entity.scalar.OlapNonScalarEntity;
import crazydev.iccube.olap.entity.set.OlapSetFactory;
import crazydev.iccube.olap.entity.set.OlapTupleSet;
import crazydev.iccube.olap.entity.tuple.OlapTuple;
import crazydev.iccube.olap.eval.execinstr.gf.context.GFContext;
import crazydev.iccube.olap.eval.execinstr.gf.function.GFFunctionArgs;
import crazydev.iccube.olap.eval.function.OlapFunctionArgs;
import crazydev.iccube.olap.eval.function.OlapFunctionArgumentType;
import crazydev.iccube.olap.eval.function.OlapNonScalarEntityFunction;
import java.util.Arrays;
import java.util.List;

public class OlapReplicateFunction
extends OlapNonScalarEntityFunction {
    public static final String NAME = "Replicate";
    public static final OlapFunctionArgs ARGS = new OlapFunctionArgs(2){

        public OlapFunctionArgumentType getType(int pos) {
            switch (pos) {
                case 1: {
                    return OlapFunctionArgumentType.VALUE;
                }
            }
            return super.getType(pos);
        }
    };

    public OlapReplicateFunction() {
        super(NAME, ARGS);
    }

    public OlapNonScalarEntity evalForCluster(GFContext context, GFFunctionArgs args) {
        int times = args.toInteger(context, 1);
        if (times <= 0) {
            return OlapSetFactory.empty();
        }
        OlapMember member = args.toMemberIfApplicable(context, 0);
        if (member != null) {
            if (member.isMdxNull()) {
                return OlapSetFactory.empty();
            }
            Object[] members = new OlapMember[times];
            Arrays.fill(members, member);
            return OlapSetFactory.instance((OlapTuple[])members);
        }
        OlapTupleSet memberSet = args.toMemberSet(context, 0, true);
        if (memberSet == null || memberSet.isMdxNull()) {
            return OlapSetFactory.empty();
        }
        List memberList = memberSet.asTupleList().getTuples();
        int listSize = memberList.size();
        if (listSize == 0) {
            return OlapSetFactory.empty();
        }
        OlapMember[] members = new OlapMember[times * listSize];
        for (int j = 0; j < times; ++j) {
            for (int i = 0; i < listSize; ++i) {
                members[j * listSize + i] = (OlapMember)memberList.get(i);
            }
        }
        return OlapSetFactory.instance((OlapTuple[])members);
    }
}

