/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.plugin.olapfunctions.others;

import crazydev.iccube.olap.entity.OlapEmptyEntity;
import crazydev.iccube.olap.entity.OlapEntity;
import crazydev.iccube.olap.entity.scalar.OlapNumericEntity;
import crazydev.iccube.olap.entity.scalar.OlapScalarEntity;
import crazydev.iccube.olap.entity.set.OlapTupleSet;
import crazydev.iccube.olap.entity.tuple.OlapTuple;
import crazydev.iccube.olap.eval.execinstr.gf.context.GFContext;
import crazydev.iccube.olap.eval.execinstr.gf.function.GFFunctionArgs;
import crazydev.iccube.olap.eval.function.OlapFunctionArgs;
import crazydev.iccube.olap.eval.function.mdx.numeric.OlapBaseGenericStatisticalFunction;
import crazydev.iccube.olap.eval.function.mdx.numeric.calculators.OlapSetCalculatorOneGenExpression;
import crazydev.iccube.olap.eval.operator.scalar.OlapScalarOperators;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;

public class OlapProdFunction
extends OlapBaseGenericStatisticalFunction {
    public static final String NAME = "Prod";
    public static final OlapFunctionArgs ARGS = new OlapFunctionArgs(1, 3){

        public boolean isLambda(int pos) {
            return pos == 1;
        }
    };

    public OlapProdFunction() {
        super(NAME, ARGS);
    }

    protected OlapSetCalculatorOneGenExpression createCalculator(GFFunctionArgs args, OlapTupleSet set) {
        final boolean includeEmpty = this.getIncludeEmpty(args);
        return new OlapSetCalculatorOneGenExpression(){
            @Nullable
            OlapScalarEntity prodValue;
            int stopIterationOrdinal;
            {
                Objects.requireNonNull(this$0);
                this.stopIterationOrdinal = -1;
            }

            public boolean isResultEmpty() {
                return this.prodValue == null || this.prodValue.isMdxNull();
            }

            public OlapEntity calculate() {
                return this.prodValue == null ? OlapProdFunction.asEmpty() : this.prodValue;
            }

            public int stopIterationOrdinal() {
                return this.stopIterationOrdinal;
            }

            public void addNull(OlapTuple setTuple, int iTupleOrdinal) {
                if (this.stopIterationOrdinal != -1) {
                    return;
                }
                if (includeEmpty) {
                    if (this.prodValue == null || this.prodValue.isMdxNull()) {
                        this.prodValue = OlapEmptyEntity.INSTANCE;
                    } else {
                        this.prodValue = this.prodValue.multiplyByZero();
                        if (this.stopIterationOrdinal != -1) {
                            this.stopIterationOrdinal = 0;
                        }
                    }
                }
            }

            public void addValue(GFContext context, OlapTuple setTuple, int iTupleOrdinal, OlapScalarEntity value) {
                if (this.stopIterationOrdinal != -1) {
                    return;
                }
                if (value.isZero()) {
                    this.prodValue = value;
                    if (this.stopIterationOrdinal != -1) {
                        this.stopIterationOrdinal = 0;
                    }
                    return;
                }
                if (this.prodValue == OlapEmptyEntity.INSTANCE) {
                    this.prodValue = value.multiplyByZero();
                    if (this.stopIterationOrdinal != -1) {
                        this.stopIterationOrdinal = 0;
                    }
                    return;
                }
                if (this.prodValue == null) {
                    if (value instanceof OlapNumericEntity) {
                        OlapNumericEntity numericEntity = (OlapNumericEntity)value;
                        this.prodValue = new OlapNumericEntity(numericEntity.doubleValue());
                    } else {
                        this.prodValue = value.asConstant();
                    }
                } else {
                    this.prodValue = OlapScalarOperators.multiply((OlapScalarEntity)this.prodValue, (OlapScalarEntity)value);
                }
            }
        };
    }
}

