/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.plugin.olapfunctions.others;

import crazydev.common.utils.CdTimeUtils;
import crazydev.iccube.builder.type.OlapBuilderInputType;
import crazydev.iccube.enums.OlapLevelType;
import crazydev.iccube.exception.OlapErrorCode;
import crazydev.iccube.olap.entity.level.OlapLevel;
import crazydev.iccube.olap.entity.member.OlapMember;
import crazydev.iccube.olap.entity.permissions.IOlapSchemaPermission;
import crazydev.iccube.olap.entity.scalar.OlapNonScalarEntity;
import crazydev.iccube.olap.entity.scalar.OlapScalarEntity;
import crazydev.iccube.olap.eval.exception.OlapFunctionEvaluationException;
import crazydev.iccube.olap.eval.execinstr.gf.context.GFContext;
import crazydev.iccube.olap.eval.execinstr.gf.function.GFFunctionArgs;
import crazydev.iccube.olap.eval.filter.dimension.OlapMemberFilter;
import crazydev.iccube.olap.eval.function.OlapFunctionArgs;
import crazydev.iccube.olap.eval.function.mdx.member.OlapMdxNavigationFunction;
import java.io.Serializable;
import org.apache.commons.lang3.mutable.MutableObject;
import org.joda.time.LocalDate;
import org.joda.time.LocalDateTime;
import org.joda.time.LocalTime;
import org.joda.time.ReadablePartial;

public class OlapLookupDateFunction
extends OlapMdxNavigationFunction {
    public static final String NAME = "LookupDate";
    public static final OlapFunctionArgs ARGS = new OlapFunctionArgs(2);

    public OlapLookupDateFunction() {
        super(NAME, ARGS);
    }

    public OlapNonScalarEntity evalForCluster(GFContext context, GFFunctionArgs args) {
        OlapLevel level = args.toLevel(context, 0);
        OlapLevelType levelType = OlapLookupDateFunction.checkLevelIsDate(context, args, level, this.getName());
        OlapScalarEntity value = args.toValue(context, 1, "scalar");
        LocalDate lookupDate = OlapLookupDateFunction.toLocalDate(context, args, value, this.getName());
        if (lookupDate == null) {
            return OlapLookupDateFunction.asNull();
        }
        IOlapSchemaPermission schemaPermissions = args.getSchemaPermissionsWithoutPerspective(context);
        OlapMemberFilter memberFilter = schemaPermissions.getDimensionsPermissions(args.getCube(context)).getMemberFilter();
        MutableObject foundMember = new MutableObject();
        level.forEachMemberWithoutAllStoppable(member -> {
            boolean noMatch;
            LocalDate start;
            if (memberFilter != null && !memberFilter.isAccepting(member)) {
                return true;
            }
            Comparable keyValue = member.getKeyValue();
            if (keyValue instanceof LocalDate) {
                start = (LocalDate)keyValue;
            } else if (keyValue instanceof LocalDateTime) {
                start = ((LocalDateTime)keyValue).toLocalDate();
            } else {
                return true;
            }
            if (levelType == OlapLevelType.DAY) {
                noMatch = !lookupDate.equals((Object)start);
            } else {
                LocalDate end = levelType.getNextDate(start.toLocalDateTime(LocalTime.MIDNIGHT)).toLocalDate();
                boolean bl = noMatch = lookupDate.isBefore((ReadablePartial)start) || CdTimeUtils.isAfterOrEquals((LocalDate)lookupDate, (LocalDate)end);
            }
            if (noMatch) {
                return true;
            }
            foundMember.setValue(member);
            return false;
        });
        return OlapLookupDateFunction.asNullable((OlapNonScalarEntity)((OlapMember)foundMember.get()));
    }

    public static LocalDate toLocalDate(GFContext context, GFFunctionArgs args, OlapScalarEntity value, String functionName) {
        LocalDate lookupDate;
        if (value.isMdxNull()) {
            return null;
        }
        if (value.isConvertibleToJavaNativeValueType(LocalDate.class)) {
            lookupDate = (LocalDate)value.asValue();
        } else if (value.isConvertibleToJavaNativeValueType(LocalDateTime.class)) {
            lookupDate = ((LocalDateTime)value.asValue()).toLocalDate();
        } else {
            throw new OlapFunctionEvaluationException(args.getErrorContext(context, 0), functionName, OlapErrorCode.FUNCTION_ARGUMENT_TYPE_MISMATCH, new Serializable[]{"date value", value.getClass().getSimpleName()});
        }
        return lookupDate;
    }

    public static OlapLevelType checkLevelIsDate(GFContext context, GFFunctionArgs args, OlapLevel level, String functionName) {
        OlapBuilderInputType[] keyType = level.getMemberKeyType();
        if (keyType == null || keyType.length != 1) {
            throw new OlapFunctionEvaluationException(args.getErrorContext(context, 0), functionName, OlapErrorCode.FUNCTION_ARGUMENT_TYPE_MISMATCH, new Serializable[]{"level-date-key", "array"});
        }
        if (!keyType[0].isDateType()) {
            throw new OlapFunctionEvaluationException(args.getErrorContext(context, 0), functionName, OlapErrorCode.FUNCTION_ARGUMENT_TYPE_MISMATCH, new Serializable[]{"level-date-key", keyType[0].getShortName()});
        }
        return level.getLevelType() == null || level.getLevelType().hasTimeInformation() ? OlapLevelType.DAY : level.getLevelType();
    }
}

