/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.plugin.olapfunctions.others;

import crazydev.iccube.collection.OlapIterator;
import crazydev.iccube.olap.entity.hierarchy.OlapHierarchy;
import crazydev.iccube.olap.entity.level.OlapLevel;
import crazydev.iccube.olap.entity.member.OlapMember;
import crazydev.iccube.olap.entity.scalar.OlapScalarEntity;
import crazydev.iccube.olap.entity.scalar.OlapStringEntity;
import crazydev.iccube.olap.entity.tuple.IOlapTuple;
import crazydev.iccube.olap.entity.tuple.OlapTuple;
import crazydev.iccube.olap.entity.tuple.OlapTupleFactory;
import crazydev.iccube.olap.entity.tuple.dimensionality.OlapTupleDimensionality;
import crazydev.iccube.olap.eval.execinstr.gf.context.GFContext;
import crazydev.iccube.olap.eval.execinstr.gf.function.GFFunctionArgs;
import crazydev.iccube.olap.eval.filter.dimension.OlapMemberFilter;
import crazydev.iccube.olap.eval.filter.dimension.OlapTupleFilter;
import crazydev.iccube.olap.eval.function.OlapFunctionArgs;
import crazydev.iccube.olap.eval.function.OlapScalarEntityFunction;
import crazydev.iccube.olap.util.IOlapExistCalculator;
import crazydev.iccube.olap.util.OlapExistCalculator;
import java.util.function.BiPredicate;

public class OlapDSColumnValueFunction
extends OlapScalarEntityFunction {
    public static final String NAME = "dsColumnValue";
    public static final OlapFunctionArgs ARGS = new OlapFunctionArgs(2);

    public OlapDSColumnValueFunction() {
        super(NAME, ARGS);
    }

    public OlapScalarEntity evalForCluster(GFContext context, GFFunctionArgs args) {
        OlapMember levelMember;
        OlapMember member = args.toMember(context, 0, true);
        OlapHierarchy hierarchy = args.toHierarchy(context, 1, true);
        OlapMemberFilter memberFilter = context.getMemberFilter();
        OlapTupleFilter tupleFilter = context.getMemberTupleFilter();
        if (member == null || hierarchy == null) {
            return OlapDSColumnValueFunction.asEmpty();
        }
        OlapTupleDimensionality dimensionality = member.getTupleDimensionality().or(hierarchy.getTupleDimensionality());
        BiPredicate<OlapMember, OlapMember> tupleExists = (member1, member2) -> {
            if (tupleFilter == null) {
                return true;
            }
            OlapTuple tuple = OlapTupleFactory.instance((OlapTupleDimensionality)dimensionality, (OlapMember[])new OlapMember[]{member, member2});
            return tupleFilter.isAccepting((IOlapTuple)tuple);
        };
        if (member.getHierarchy().hasOneRelationWithBase(hierarchy)) {
            OlapMember attributeMember = member.getAttributeMember(hierarchy);
            if (attributeMember == null || memberFilter != null && !memberFilter.isAccepting(member)) {
                return OlapDSColumnValueFunction.asEmpty();
            }
            if (!tupleExists.test(member, attributeMember)) {
                return OlapDSColumnValueFunction.asEmpty();
            }
            String caption = OlapDSColumnValueFunction.getCaption(context, attributeMember);
            return new OlapStringEntity(caption);
        }
        OlapLevel lastLevel = hierarchy.getLastLevel();
        OlapIterator iter = lastLevel.getMembers(memberFilter).getIterator(false);
        IOlapExistCalculator calculator = null;
        StringBuilder captionsAsString = new StringBuilder();
        iter.reset();
        while ((levelMember = (OlapMember)iter.next()) != null) {
            if (!(calculator = calculator == null ? OlapExistCalculator.create((OlapTuple)member, (OlapTuple)levelMember) : calculator).exists((OlapTuple)member, (OlapTuple)levelMember) || !tupleExists.test(member, levelMember)) continue;
            captionsAsString.append(captionsAsString.length() == 0 ? "" : ", ");
            captionsAsString.append(OlapDSColumnValueFunction.getCaption(context, levelMember));
        }
        if (captionsAsString.length() == 0) {
            return OlapDSColumnValueFunction.asEmpty();
        }
        return new OlapStringEntity(captionsAsString.toString());
    }

    private static String getCaption(GFContext context, OlapMember levelMember) {
        return levelMember.getCaption(context.getLocale(), context.getNameContext());
    }
}

