/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.plugin.olapfunctions.others;

import crazydev.iccube.collection.OlapIterator;
import crazydev.iccube.collection.olapiterator.OlapIteratorFactory;
import crazydev.iccube.olap.entity.member.OlapMember;
import crazydev.iccube.olap.entity.scalar.OlapNonScalarEntity;
import crazydev.iccube.olap.entity.set.OlapListTupleSet;
import crazydev.iccube.olap.entity.set.OlapSetFactory;
import crazydev.iccube.olap.entity.set.OlapTupleSet;
import crazydev.iccube.olap.entity.tuple.OlapTuple;
import crazydev.iccube.olap.entity.tuple.dimensionality.OlapTupleDimensionality;
import crazydev.iccube.olap.entity.tuple.dimensionality.OlapTupleDimensionalityFactory;
import crazydev.iccube.olap.eval.execinstr.OlapPreparedInstr;
import crazydev.iccube.olap.eval.execinstr.gf.context.GFContext;
import crazydev.iccube.olap.eval.execinstr.gf.function.GFFunctionArgs;
import crazydev.iccube.olap.eval.execinstr.gf.nodes.GFNode;
import crazydev.iccube.olap.eval.function.OlapEntityFunction;
import crazydev.iccube.olap.eval.function.OlapFunctionArgs;
import crazydev.iccube.olap.eval.function.OlapFunctionCallInstr;
import crazydev.iccube.olap.eval.instr.OlapInstr;
import crazydev.iccube.olap.eval.select.context.IOlapPrepareContext;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Nullable;

public class OlapCombineFunction
extends OlapEntityFunction {
    public static final String NAME = "Combine";
    public static final OlapFunctionArgs ARGS = new OlapFunctionArgs(0, Integer.MAX_VALUE){

        public boolean isLambda(int pos) {
            return pos >= 1;
        }
    };

    public OlapCombineFunction() {
        super(NAME, ARGS);
    }

    @Nullable
    public OlapTupleDimensionality getTupleDimensionality(GFNode[] args) {
        List dimensionalities = Arrays.stream(args).map(GFNode::getTupleDimensionality).collect(Collectors.toList());
        return OlapTupleDimensionalityFactory.createUnionEx(dimensionalities);
    }

    protected OlapPreparedInstr doPrepareFunctionCall(IOlapPrepareContext context, OlapFunctionCallInstr callInstr, OlapInstr[] args, OlapPreparedInstr[] pArgs) {
        return super.doPrepareFunctionCall(context, callInstr, args, pArgs);
    }

    public OlapNonScalarEntity evalForCluster(GFContext context, GFFunctionArgs args) {
        int argNumber = args.getArgLength();
        if (argNumber == 0) {
            return OlapSetFactory.empty();
        }
        if (argNumber == 1) {
            return args.toSet(context, 0);
        }
        OlapTupleDimensionality dimSet = null;
        ArrayList setOfSets = new ArrayList();
        boolean sameHierarchy = true;
        for (int i = 0; i < argNumber; ++i) {
            OlapTupleSet olapSet = args.toSet(context, i);
            OlapListTupleSet olapList = olapSet == null ? OlapSetFactory.empty() : olapSet.asTupleList();
            OlapTupleDimensionality setDimensionality = olapList.getTupleDimensionality();
            if (setDimensionality == null || setDimensionality.cardinality() != 1 || dimSet != null && !dimSet.intersects(setDimensionality)) {
                sameHierarchy = false;
            }
            dimSet = setDimensionality;
            setOfSets.add((OlapTupleSet<?>)olapList);
        }
        if (setOfSets.isEmpty()) {
            return OlapSetFactory.empty();
        }
        if (sameHierarchy) {
            return this.doSameHierarchyMember(setOfSets);
        }
        return this.doCrossjoin(context, args, setOfSets);
    }

    private OlapNonScalarEntity doCrossjoin(GFContext context, GFFunctionArgs args, List<OlapTupleSet<?>> setOfSets) {
        OlapIterator iterator = OlapIteratorFactory.crossjoin((GFContext)context, (GFFunctionArgs)args, (boolean)true, setOfSets);
        return OlapSetFactory.instance((OlapIterator)iterator);
    }

    private OlapNonScalarEntity doSameHierarchyMember(ArrayList<OlapTupleSet<? extends OlapTuple>> setOfSets) {
        int i;
        List<ArrayList<OlapMember>> listOfMemberList = setOfSets.stream().filter(set -> !set._isEmpty()).map(set -> new ArrayList(set.asTupleList().getTuples())).collect(Collectors.toList());
        ArrayList<OlapTuple> outputSet = new ArrayList<OlapTuple>();
        for (i = 0; i < ((ArrayList)listOfMemberList.get(0)).size(); ++i) {
            OlapMember member = (OlapMember)((ArrayList)listOfMemberList.get(0)).get(i);
            outputSet.add((OlapTuple)member);
            this.addDescendants(listOfMemberList, outputSet, member, 1);
        }
        for (i = 1; i < listOfMemberList.size(); ++i) {
            ArrayList list = (ArrayList)listOfMemberList.get(i);
            for (int j = 0; j < list.size(); ++j) {
                OlapMember olapMember = (OlapMember)list.get(j);
                if (olapMember == null) continue;
                outputSet.add((OlapTuple)olapMember);
            }
        }
        return OlapSetFactory.instance(outputSet);
    }

    private void addDescendants(List<ArrayList<OlapMember>> setList, ArrayList<OlapTuple> outputSet, OlapMember parentMember, int setIdx) {
        if (setIdx >= setList.size()) {
            return;
        }
        ArrayList<OlapMember> set = setList.get(setIdx);
        for (int i = 0; i < set.size(); ++i) {
            OlapMember member = set.get(i);
            if (member == null || !member.isDescendant(parentMember)) continue;
            set.set(i, null);
            outputSet.add((OlapTuple)member);
            this.addDescendants(setList, outputSet, member, setIdx + 1);
        }
    }
}

