/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.plugin.olapfunctions.others;

import crazydev.common.utils.CdStringUtils;
import crazydev.iccube.exception.OlapErrorCode;
import crazydev.iccube.olap.component.OlapEngineComponent;
import crazydev.iccube.olap.entity.member.OlapMeasureMember;
import crazydev.iccube.olap.entity.member.OlapMember;
import crazydev.iccube.olap.entity.scalar.OlapNonScalarEntity;
import crazydev.iccube.olap.eval.exception.IOlapEvaluationExceptionContext;
import crazydev.iccube.olap.eval.execinstr.gf.context.GFContext;
import crazydev.iccube.olap.eval.execinstr.gf.function.GFFunctionArgs;
import crazydev.iccube.olap.eval.facts.aggregation.table.IOlapFactTableAggregatorFactory;
import crazydev.iccube.olap.eval.facts.aggregation.table.OlapTableAggregatorRepository;
import crazydev.iccube.olap.eval.function.OlapFunctionArgs;
import crazydev.iccube.olap.eval.function.OlapFunctionArgumentType;
import crazydev.iccube.olap.eval.function.mdx.member.OlapMdxNavigationFunction;
import java.io.Serializable;

public class OlapAddTableAggregrationFunction
extends OlapMdxNavigationFunction {
    public static final String NAME = "AddTableAggregation";
    public static final OlapFunctionArgs ARGS = new OlapFunctionArgs(2){

        public OlapFunctionArgumentType getType(int pos) {
            switch (pos) {
                case 1: {
                    return OlapFunctionArgumentType.VALUE;
                }
            }
            return super.getType(pos);
        }
    };

    public OlapAddTableAggregrationFunction() {
        super(NAME, ARGS);
    }

    public OlapNonScalarEntity evalForCluster(GFContext context, GFFunctionArgs args) {
        OlapMember member = args.toMember(context, 0);
        String className = args.toString(context, 1);
        if (member instanceof OlapMeasureMember) {
            OlapMeasureMember measureMember = (OlapMeasureMember)member;
            OlapEngineComponent engine = context.getRequestContext().getOlapEngineComponent();
            OlapTableAggregatorRepository repository = engine.getTableAggregationRepository();
            if (CdStringUtils.isNullOrBlank((String)className)) {
                measureMember.setTableAggregator(null);
            } else {
                IOlapFactTableAggregatorFactory tableAggregator = repository.lookupAggregator(className);
                if (tableAggregator == null) {
                    return (OlapNonScalarEntity)this.onFunctionError((IOlapEvaluationExceptionContext)context, OlapErrorCode.TABLE_AGGR_MISSING, new Serializable[]{className});
                }
                measureMember.setTableAggregator(tableAggregator);
            }
        }
        return member;
    }
}

