/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.plugin.olapfunctions.excel;

import crazydev.common.utils.CdTimeUtils;
import crazydev.iccube.plugin.function.OlapPluginEvaluationException;
import crazydev.iccube.plugin.function.OlapPluginUserJavaFunction;
import org.joda.time.LocalDate;
import org.joda.time.LocalDateTime;

public class OlapVBExcelDateFunctions {
    public static final OlapPluginUserJavaFunction NOW = new OlapPluginUserJavaFunction(0, 0, new Class[0]){

        protected Object doEval(Object[] args) {
            LocalDate ic3 = CdTimeUtils.redefinedToday();
            if (ic3 != null) {
                LocalDateTime now = new LocalDateTime();
                return new LocalDateTime(ic3.getYear(), ic3.getMonthOfYear(), ic3.getDayOfMonth(), now.getHourOfDay(), now.getMinuteOfHour());
            }
            return LocalDateTime.now().withMillisOfSecond(0);
        }
    };
    public static final OlapPluginUserJavaFunction YEAR = new OneArg(){

        @Override
        protected Object evaluate(LocalDate date) {
            return date.getYear();
        }

        @Override
        protected Object evaluate(LocalDateTime date) {
            return date.getYear();
        }
    };
    public static final OlapPluginUserJavaFunction MONTH = new OneArg(){

        @Override
        protected Object evaluate(LocalDate date) {
            return date.getMonthOfYear();
        }

        @Override
        protected Object evaluate(LocalDateTime date) {
            return date.getMonthOfYear();
        }
    };
    public static final OlapPluginUserJavaFunction DAY = new OneArg(){

        @Override
        protected Object evaluate(LocalDate date) {
            return date.getDayOfMonth();
        }

        @Override
        protected Object evaluate(LocalDateTime date) {
            return date.getDayOfMonth();
        }
    };

    public static abstract class OneArg
    extends OlapPluginUserJavaFunction {
        protected OneArg() {
            super(1, 1, new Class[]{Object.class});
        }

        public final Object doEval(Object[] args) throws OlapPluginEvaluationException {
            Object date = args[0];
            if (date instanceof LocalDate) {
                return this.evaluate((LocalDate)date);
            }
            if (date instanceof LocalDateTime) {
                return this.evaluate((LocalDateTime)date);
            }
            throw new OlapPluginEvaluationException(OlapPluginEvaluationException.Kind.VALUE_INVALID, "argument type is " + date.getClass().getName());
        }

        protected abstract Object evaluate(LocalDate var1);

        protected abstract Object evaluate(LocalDateTime var1);
    }
}

