/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.plugin.olapfunctions.excel;

import crazydev.iccube.plugin.function.OlapPluginEvaluationException;
import crazydev.iccube.plugin.function.OlapPluginUserJavaFunction;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import org.joda.time.CdJodaTimeUtil;
import org.joda.time.LocalDate;
import org.joda.time.LocalDateTime;

public class OlapVBExcelConversionFunctions {
    private static final SimpleDateFormat[] DATE_FORMATS = new SimpleDateFormat[]{new SimpleDateFormat("yyyy-MM-dd", Locale.US), new SimpleDateFormat("M/d/y h:m:s", Locale.US), new SimpleDateFormat("M/d/y h:m:s", Locale.US), new SimpleDateFormat("M/d/y h:m", Locale.US), new SimpleDateFormat("M/d/y", Locale.US), new SimpleDateFormat("M-d-y h:m:s", Locale.US), new SimpleDateFormat("M-d-y h:m", Locale.US), new SimpleDateFormat("M-d-y", Locale.US), new SimpleDateFormat("h:m:s", Locale.US), new SimpleDateFormat("h:m", Locale.US)};
    public static final OlapPluginUserJavaFunction CDate = new OlapPluginUserJavaFunction(1, 1, new Class[]{String.class}){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Object doEval(Object[] args) throws OlapPluginEvaluationException {
            String dateAsString = (String)args[0];
            if (dateAsString == null) {
                return null;
            }
            int pos = dateAsString.indexOf("-");
            boolean useUniversal = pos == 4;
            SimpleDateFormat[] simpleDateFormatArray = DATE_FORMATS;
            synchronized (DATE_FORMATS) {
                for (int idx = 0; idx < DATE_FORMATS.length; ++idx) {
                    if (idx == 0 && !useUniversal) continue;
                    SimpleDateFormat format = DATE_FORMATS[idx];
                    try {
                        Date date = format.parse(dateAsString);
                        // ** MonitorExit[var5_5] (shouldn't be in output)
                        return new LocalDateTime((Object)date);
                    }
                    catch (ParseException parseException) {
                        // empty catch block
                    }
                }
                // ** MonitorExit[var5_5] (shouldn't be in output)
                throw new RuntimeException("CDate: unable to parse date [" + dateAsString + "]");
            }
        }
    };
    public static final OlapPluginUserJavaFunction CDbl = new OneArg(){

        @Override
        protected Object evaluate(Object d) throws OlapPluginEvaluationException {
            if (d == null) {
                return null;
            }
            if (d instanceof String) {
                return Double.valueOf((String)d);
            }
            if (d instanceof Float) {
                return ((Float)d).doubleValue();
            }
            if (d instanceof Double) {
                return d;
            }
            if (d instanceof Long) {
                return ((Long)d).doubleValue();
            }
            if (d instanceof Integer) {
                return ((Integer)d).doubleValue();
            }
            if (d instanceof Short) {
                return ((Short)d).doubleValue();
            }
            if (d instanceof Byte) {
                return ((Byte)d).doubleValue();
            }
            throw new RuntimeException("CDbl: invalid argument type [" + String.valueOf(d) + "]");
        }
    };
    public static final OlapPluginUserJavaFunction CLng = new OneArg(){

        @Override
        protected Object evaluate(Object d) throws OlapPluginEvaluationException {
            if (d == null) {
                return null;
            }
            if (d instanceof String) {
                return Integer.valueOf((String)d);
            }
            if (d instanceof Float) {
                return Double.valueOf(Math.rint(((Float)d).floatValue())).intValue();
            }
            if (d instanceof Double) {
                return Double.valueOf(Math.rint((Double)d)).intValue();
            }
            if (d instanceof Long) {
                return ((Long)d).intValue();
            }
            if (d instanceof Integer) {
                return d;
            }
            if (d instanceof Short) {
                return ((Short)d).intValue();
            }
            if (d instanceof Byte) {
                return ((Byte)d).intValue();
            }
            throw new RuntimeException("CLng: invalid argument type [" + String.valueOf(d) + "]");
        }
    };
    public static final OlapPluginUserJavaFunction CLngLng = new OneArg(){

        @Override
        protected Object evaluate(Object d) throws OlapPluginEvaluationException {
            if (d == null) {
                return null;
            }
            if (d instanceof String) {
                return Long.valueOf((String)d);
            }
            if (d instanceof Float) {
                return Double.valueOf(Math.rint(((Float)d).floatValue())).longValue();
            }
            if (d instanceof Double) {
                return Double.valueOf(Math.rint((Double)d)).longValue();
            }
            if (d instanceof Long) {
                return d;
            }
            if (d instanceof Integer) {
                return ((Integer)d).longValue();
            }
            if (d instanceof Short) {
                return ((Short)d).longValue();
            }
            if (d instanceof Byte) {
                return ((Byte)d).longValue();
            }
            throw new RuntimeException("CLngLng: invalid argument type [" + String.valueOf(d) + "]");
        }
    };
    public static final OlapPluginUserJavaFunction CSng = new OneArg(){

        @Override
        protected Object evaluate(Object d) throws OlapPluginEvaluationException {
            if (d == null) {
                return null;
            }
            if (d instanceof String) {
                return Float.valueOf((String)d);
            }
            if (d instanceof Float) {
                return d;
            }
            if (d instanceof Double) {
                return Float.valueOf(((Double)d).floatValue());
            }
            if (d instanceof Long) {
                return Float.valueOf(((Long)d).floatValue());
            }
            if (d instanceof Integer) {
                return Float.valueOf(((Integer)d).floatValue());
            }
            if (d instanceof Short) {
                return Float.valueOf(((Short)d).floatValue());
            }
            if (d instanceof Byte) {
                return Float.valueOf(((Byte)d).floatValue());
            }
            throw new RuntimeException("CSng: invalid argument type [" + String.valueOf(d) + "]");
        }
    };
    public static final OlapPluginUserJavaFunction CStr = new OneArg(){

        @Override
        protected Object evaluate(Object d) throws OlapPluginEvaluationException {
            if (d == null) {
                return null;
            }
            if (d instanceof String) {
                return d;
            }
            if (d instanceof Boolean) {
                return (Boolean)d != false ? "True" : "False";
            }
            if (d instanceof Float) {
                return d.toString();
            }
            if (d instanceof Double) {
                return d.toString();
            }
            if (d instanceof Long) {
                return d.toString();
            }
            if (d instanceof Integer) {
                return d.toString();
            }
            if (d instanceof Short) {
                return d.toString();
            }
            if (d instanceof Byte) {
                return d.toString();
            }
            if (d instanceof Date) {
                return d.toString();
            }
            if (d instanceof LocalDateTime) {
                return d.toString();
            }
            if (d instanceof LocalDate) {
                return d.toString();
            }
            throw new RuntimeException("CStr: invalid argument type [" + String.valueOf(d) + "]");
        }
    };
    public static final OlapPluginUserJavaFunction Val = new OneArg(){

        @Override
        protected Object evaluate(Object d) throws OlapPluginEvaluationException {
            if (d == null) {
                return 0;
            }
            if (d instanceof String) {
                return this.evaluateForString((String)d);
            }
            if (d instanceof Boolean) {
                return (Boolean)d != false ? -1 : 0;
            }
            if (d instanceof Float) {
                return d;
            }
            if (d instanceof Double) {
                return d;
            }
            if (d instanceof Long) {
                return d;
            }
            if (d instanceof Integer) {
                return d;
            }
            if (d instanceof Short) {
                return d;
            }
            if (d instanceof Byte) {
                return d;
            }
            if (d instanceof Date) {
                return ((Date)d).getTime();
            }
            if (d instanceof LocalDateTime) {
                return CdJodaTimeUtil.toDefaultChronologyMillis((LocalDateTime)((LocalDateTime)d));
            }
            if (d instanceof LocalDate) {
                return CdJodaTimeUtil.toDefaultChronologyDays((LocalDate)((LocalDate)d));
            }
            throw new RuntimeException("Val: invalid argument type [" + String.valueOf(d) + "]");
        }

        private Object evaluateForString(String str) {
            ValStringEvaluator evaluator = new ValStringEvaluator(str);
            return evaluator.evaluate();
        }
    };

    public static final class ValStringEvaluator {
        private final String str;
        private final StringBuilder sb = new StringBuilder();
        private int pos = 0;

        public ValStringEvaluator(String str) {
            this.str = str;
        }

        public Object evaluate() {
            String valueAsString;
            boolean hasExponentMarker;
            if (this.str.isEmpty()) {
                return 0;
            }
            this.eatWhiteSpaces();
            this.scanOptionalSign();
            boolean hasDigit = this.scanDigits();
            boolean hasDot = this.scanOptionalDot();
            if (!hasDigit && !hasDot) {
                return 0;
            }
            if (hasDot) {
                this.scanDigits();
            }
            if (hasExponentMarker = this.scanOptionalExponentMarker()) {
                int exponentMarkerPos = this.pos - 1;
                this.eatWhiteSpaces();
                this.scanOptionalSign();
                boolean hasExponent = this.scanDigits();
                if (!hasExponent) {
                    String val = this.sb.toString();
                    this.sb.delete(0, val.length());
                    this.sb.append(val.substring(0, exponentMarkerPos));
                }
            }
            if ((valueAsString = this.sb.toString()).length() == 0) {
                return 0;
            }
            double value = Double.parseDouble(valueAsString);
            if (value > 9.223372036854776E18 || value < -9.223372036854776E18) {
                return value;
            }
            long valueAsLong = (long)value;
            if ((double)valueAsLong == value) {
                return valueAsLong;
            }
            return value;
        }

        private void eatWhiteSpaces() {
            while (this.pos < this.str.length() && Character.isSpaceChar(this.str.charAt(this.pos))) {
                ++this.pos;
            }
        }

        private void scanOptionalSign() {
            char cc;
            if (this.pos < this.str.length() && ('+' == (cc = this.str.charAt(this.pos)) || '-' == cc)) {
                this.sb.append(cc);
                ++this.pos;
            }
        }

        private boolean scanDigits() {
            boolean hasDigit = false;
            while (this.pos < this.str.length()) {
                char cc = this.str.charAt(this.pos);
                if (cc >= '0' && cc <= '9') {
                    hasDigit = true;
                    this.sb.append(cc);
                    ++this.pos;
                    continue;
                }
                if (!Character.isSpaceChar(cc)) break;
                ++this.pos;
            }
            return hasDigit;
        }

        private boolean scanOptionalDot() {
            char cc;
            if (this.pos < this.str.length() && '.' == (cc = this.str.charAt(this.pos))) {
                this.sb.append(cc);
                ++this.pos;
                return true;
            }
            return false;
        }

        private boolean scanOptionalExponentMarker() {
            char cc;
            if (this.pos < this.str.length() && ('e' == (cc = this.str.charAt(this.pos)) || 'E' == cc)) {
                this.sb.append(cc);
                ++this.pos;
                return true;
            }
            return false;
        }
    }

    public static abstract class OneArg
    extends OlapPluginUserJavaFunction {
        protected OneArg() {
            super(1, new Class[]{Object.class});
        }

        public final Object doEval(Object[] args) throws OlapPluginEvaluationException {
            return this.evaluate(args[0]);
        }

        protected abstract Object evaluate(Object var1) throws OlapPluginEvaluationException;
    }
}

