/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.plugin.method;

import crazydev.iccube.exception.OlapErrorCode;
import crazydev.iccube.olap.entity.OlapEntity;
import crazydev.iccube.olap.entity.tuple.dimensionality.OlapTupleDimensionality;
import crazydev.iccube.olap.eval.exception.IOlapEvaluationExceptionContext;
import crazydev.iccube.olap.eval.exception.OlapEvaluationException;
import crazydev.iccube.olap.eval.execinstr.gf.context.GFContext;
import crazydev.iccube.olap.eval.execinstr.gf.nodes.GFNode;
import crazydev.iccube.olap.eval.execinstr.gf.tupleevaluator.GFTupleEvaluator;
import crazydev.iccube.olap.eval.instr.OlapInstrLocationRange;
import crazydev.iccube.olap.eval.method.OlapJavaMethod;
import crazydev.iccube.olap.eval.method.OlapJavaMethodHelper;
import crazydev.iccube.olap.loggers.OlapLoggers;
import crazydev.iccube.plugin.method.OlapJModuleNativeFunctionInstr;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GFJNativeFunctionNode
extends GFNode {
    private final OlapJModuleNativeFunctionInstr instr;

    public GFJNativeFunctionNode(boolean markedForValueEvaluation, OlapJModuleNativeFunctionInstr instr) {
        super(markedForValueEvaluation);
        this.instr = instr;
    }

    public OlapInstrLocationRange getLocationRange() {
        return this.instr.getLocationRange();
    }

    public String getMdxForDrillthrough() {
        return this.instr.getMdxForDrillthrough();
    }

    @Nullable
    public OlapTupleDimensionality getTupleDimensionality() {
        return null;
    }

    protected OlapEntity evaluate(GFContext context, GFTupleEvaluator evaluator) {
        if (!context.isJavaMdxNativesActivated()) {
            throw new OlapEvaluationException((IOlapEvaluationExceptionContext)context, OlapErrorCode.NATIVE_METHOD_EXEC_ERROR, new Serializable[]{"functions", "", "JAVA native functions are not active"});
        }
        if (this.instr.isWithFunction()) {
            throw new OlapEvaluationException((IOlapEvaluationExceptionContext)context, OlapErrorCode.NATIVE_METHOD_EXEC_ERROR, new Serializable[]{"functions", "", "JAVA native functions cannot be defined in a SELECT statement (i.e., WITH NATIVE ...)"});
        }
        OlapJavaMethod method = null;
        try {
            method = this.instr.resolveJavaNativeMethod(context);
            return this.doEvaluate(context, evaluator, method);
        }
        catch (ClassNotFoundException ex) {
            OlapLoggers.MDX_EVALUATION.error((Object)this.getErrorMessage(method), (Throwable)ex);
            throw new OlapEvaluationException((IOlapEvaluationExceptionContext)context, OlapErrorCode.JAVA_CLASS_UNKNOWN, new Serializable[]{"icCube.nativeFunctions." + this.instr.getFunctionName()});
        }
        catch (InvocationTargetException ex) {
            OlapLoggers.MDX_EVALUATION.error((Object)this.getErrorMessage(method), (Throwable)ex);
            throw new OlapEvaluationException((IOlapEvaluationExceptionContext)context, OlapErrorCode.METHOD_EXEC_ERROR, new Serializable[]{this.getModulePrefix(), this.getMethodName(), String.valueOf(ex.getTargetException())});
        }
        catch (IllegalAccessException ex) {
            OlapLoggers.MDX_EVALUATION.error((Object)this.getErrorMessage(method), (Throwable)ex);
            throw new OlapEvaluationException((IOlapEvaluationExceptionContext)context, OlapErrorCode.METHOD_EXEC_ERROR, new Serializable[]{this.getModulePrefix(), this.getMethodName(), String.valueOf(ex)});
        }
        catch (InstantiationException ex) {
            OlapLoggers.MDX_EVALUATION.error((Object)this.getErrorMessage(method), (Throwable)ex);
            throw new OlapEvaluationException((IOlapEvaluationExceptionContext)context, OlapErrorCode.METHOD_FIELD_UNKNOWN, new Serializable[]{this.getModulePrefix(), this.getMethodName(), String.valueOf(ex)});
        }
        catch (NoSuchMethodException ex) {
            OlapLoggers.MDX_EVALUATION.error((Object)this.getErrorMessage(method), (Throwable)ex);
            throw new OlapEvaluationException((IOlapEvaluationExceptionContext)context, OlapErrorCode.METHOD_UNKNOWN, new Serializable[]{this.getModulePrefix(), this.getMethodName(), String.valueOf(ex)});
        }
        catch (RuntimeException ex) {
            if (ex instanceof OlapEvaluationException) {
                throw ex;
            }
            OlapLoggers.MDX_EVALUATION.error((Object)this.getErrorMessage(method), (Throwable)ex);
            throw new OlapEvaluationException((IOlapEvaluationExceptionContext)context, OlapErrorCode.METHOD_EXEC_ERROR, new Serializable[]{this.getModulePrefix(), this.getMethodName(), String.valueOf(ex)});
        }
    }

    @NotNull
    private String getErrorMessage(@Nullable OlapJavaMethod method) {
        if (method == null || method.getOffset() == -1) {
            return this.getModuleName() + " Method Error ( " + this.getMethodName() + " )";
        }
        return this.getModuleName() + " Method Error ( " + this.getMethodName() + " [code-offset:" + method.getOffset() + "] )";
    }

    private String getModuleName() {
        return "JAVA";
    }

    private String getModulePrefix() {
        return "JAVA!";
    }

    private String getMethodName() {
        return this.instr.getFunctionName();
    }

    private OlapEntity doEvaluate(GFContext context, GFTupleEvaluator evaluator, OlapJavaMethod method) throws IllegalAccessException, InstantiationException, InvocationTargetException {
        Object javaResult;
        int argCount = this.instr.getFunctionArgCount();
        if (argCount == 0) {
            javaResult = method.invoke(null, new Object[0]);
        } else {
            OlapEntity[] mdxParams = new OlapEntity[argCount];
            for (int ii = 0; ii < argCount; ++ii) {
                mdxParams[ii] = context.lookupDeclaredFunctionArgument(ii);
            }
            Object[] javaParams = OlapJavaMethodHelper.convertScalarEntityParamsToJavaNativeValues((OlapInstrLocationRange)this.getLocationRange(), (OlapJavaMethod)method, (OlapEntity[])mdxParams);
            javaResult = method.invoke(null, javaParams);
        }
        OlapEntity mdxResult = OlapJavaMethodHelper.convertJavaResultToEntity((GFContext)context, (GFTupleEvaluator)evaluator, (Object)javaResult);
        return mdxResult;
    }
}

