/*
 * Decompiled with CFR 0.152.
 */
package io.trino.jdbc;

import io.trino.jdbc.;
import io.trino.jdbc.$internal.client.UserAgentBuilder;
import io.trino.jdbc.$internal.client.uri.HttpClientFactory;
import io.trino.jdbc.$internal.okhttp3.ConnectionPool;
import io.trino.jdbc.$internal.okhttp3.Dispatcher;
import io.trino.jdbc.DriverInfo;
import io.trino.jdbc.TrinoConnection;
import io.trino.jdbc.TrinoDriverUri;
import java.io.Closeable;
import java.io.IOException;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Properties;
import java.util.logging.Logger;

public class NonRegisteringTrinoDriver
implements Driver,
Closeable {
    private static final String USER_AGENT = UserAgentBuilder.createUserAgent(DriverInfo.DRIVER_NAME, DriverInfo.DRIVER_VERSION);
    private final Dispatcher dispatcher = new Dispatcher();
    private final ConnectionPool pool = new ConnectionPool();

    protected NonRegisteringTrinoDriver() {
    }

    @Override
    public void close() throws IOException {
        this.dispatcher.executorService().shutdown();
        this.pool.evictAll();
    }

    @Override
    public Connection connect(String url, Properties info) throws SQLException {
        if (!this.acceptsURL(url)) {
            return null;
        }
        try {
            TrinoDriverUri uri = TrinoDriverUri.createDriverUri(url, info);
            .OkHttpClient.Builder httpClientBuilder = HttpClientFactory.toHttpClientBuilder(uri, USER_AGENT);
            httpClientBuilder.connectionPool(this.pool);
            httpClientBuilder.dispatcher(this.dispatcher);
            .OkHttpClient.Builder segmentHttpClientBuilder = HttpClientFactory.unauthenticatedClientBuilder(uri, USER_AGENT);
            segmentHttpClientBuilder.connectionPool(this.pool);
            segmentHttpClientBuilder.dispatcher(this.dispatcher);
            return new TrinoConnection(uri, this.wrapClient(httpClientBuilder.build()), this.wrapClient(segmentHttpClientBuilder.build()));
        }
        catch (RuntimeException e) {
            throw new SQLException(e.getMessage(), e);
        }
    }

    protected .Call.Factory wrapClient(.OkHttpClient client) {
        return client;
    }

    @Override
    public boolean acceptsURL(String url) throws SQLException {
        if (url == null) {
            throw new SQLException("URL is null");
        }
        return TrinoDriverUri.acceptsURL(url);
    }

    @Override
    public DriverPropertyInfo[] getPropertyInfo(String url, Properties info) {
        return TrinoDriverUri.getPropertyInfo(url, info);
    }

    @Override
    public int getMajorVersion() {
        return DriverInfo.DRIVER_VERSION_MAJOR;
    }

    @Override
    public int getMinorVersion() {
        return DriverInfo.DRIVER_VERSION_MINOR;
    }

    @Override
    public boolean jdbcCompliant() {
        return false;
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException();
    }
}

