/*
 * Decompiled with CFR 0.152.
 */
package io.trino.jdbc.$internal.client.spooling.encoding;

import io.trino.jdbc.$internal.airlift.compress.lz4.Lz4Decompressor;
import io.trino.jdbc.$internal.airlift.compress.zstd.ZstdDecompressor;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.Optional;

public class DecompressionUtils {
    private static final MethodHandles.Lookup LOOKUP = MethodHandles.lookup();
    private static final Optional<MethodHandle> LZ4_DECOMPRESSOR_CONSTRUCTOR = DecompressionUtils.getDecompressorConstructor("io.trino.jdbc.$internal.airlift.compress.v3.lz4.Lz4NativeDecompressor");
    private static final Optional<MethodHandle> ZSTD_DECOMPRESSOR_CONSTRUCTOR = DecompressionUtils.getDecompressorConstructor("io.trino.jdbc.$internal.airlift.compress.v3.zstd.ZstdNativeDecompressor");

    private DecompressionUtils() {
    }

    public static int decompressLZ4(byte[] input, byte[] output) {
        if (LZ4_DECOMPRESSOR_CONSTRUCTOR.isEmpty()) {
            Lz4Decompressor decompressor = new Lz4Decompressor();
            return decompressor.decompress(input, 0, input.length, output, 0, output.length);
        }
        return DecompressionUtils.decompressNative(LZ4_DECOMPRESSOR_CONSTRUCTOR.get(), input, output);
    }

    public static int decompressZstd(byte[] input, byte[] output) {
        if (ZSTD_DECOMPRESSOR_CONSTRUCTOR.isEmpty()) {
            ZstdDecompressor decompressor = new ZstdDecompressor();
            return decompressor.decompress(input, 0, input.length, output, 0, output.length);
        }
        return DecompressionUtils.decompressNative(ZSTD_DECOMPRESSOR_CONSTRUCTOR.get(), input, output);
    }

    private static int decompressNative(MethodHandle constructor, byte[] input, byte[] output) {
        try {
            Object decompressor = constructor.invoke();
            MethodHandle decompress = LOOKUP.findVirtual(decompressor.getClass(), "decompress", MethodType.methodType(Integer.TYPE, byte[].class, Integer.TYPE, Integer.TYPE, byte[].class, Integer.TYPE, Integer.TYPE));
            return decompress.invoke(decompressor, input, 0, input.length, output, 0, output.length);
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    private static Optional<MethodHandle> getDecompressorConstructor(String clazzName) {
        try {
            Class<?> clazz = Class.forName(clazzName);
            MethodHandle constructor = LOOKUP.findConstructor(clazz, MethodType.methodType(Void.TYPE));
            MethodHandle isEnabled = LOOKUP.findStatic(clazz, "isEnabled", MethodType.methodType(Boolean.TYPE));
            if (!isEnabled.invoke()) {
                return Optional.empty();
            }
            return Optional.of(constructor);
        }
        catch (Throwable e) {
            return Optional.empty();
        }
    }
}

