/*
 * Decompiled with CFR 0.152.
 */
package io.trino.jdbc.$internal.client.spooling;

import io.trino.jdbc.$internal.client.CloseableIterator;
import io.trino.jdbc.$internal.client.QueryDataDecoder;
import io.trino.jdbc.$internal.client.spooling.InlineSegment;
import io.trino.jdbc.$internal.client.spooling.InlineSegmentIterator;
import io.trino.jdbc.$internal.client.spooling.Segment;
import io.trino.jdbc.$internal.client.spooling.SegmentLoader;
import io.trino.jdbc.$internal.client.spooling.SpooledSegment;
import io.trino.jdbc.$internal.client.spooling.SpooledSegmentIterator;
import io.trino.jdbc.$internal.guava.base.Verify;
import io.trino.jdbc.$internal.guava.collect.AbstractIterator;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.List;
import java.util.Objects;

public class SegmentsIterator
extends AbstractIterator<List<Object>>
implements CloseableIterator<List<Object>> {
    private final SegmentLoader loader;
    private final QueryDataDecoder decoder;
    private final Deque<Segment> remainingSegments;
    private CloseableIterator<List<Object>> currentIterator;

    public SegmentsIterator(SegmentLoader loader, QueryDataDecoder decoder, List<Segment> segments) {
        Verify.verify(!segments.isEmpty(), "Expected at least a single segment to iterate over", new Object[0]);
        this.loader = Objects.requireNonNull(loader, "loader is null");
        this.decoder = Objects.requireNonNull(decoder, "decoder is null");
        this.remainingSegments = new ArrayDeque<Segment>(segments);
        this.currentIterator = this.iterate(this.remainingSegments.removeFirst());
    }

    @Override
    protected List<Object> computeNext() {
        if (this.currentIterator.hasNext()) {
            return (List)this.currentIterator.next();
        }
        if (this.moveToNextIterator()) {
            Verify.verify(this.currentIterator.hasNext(), "New current iterator is empty", new Object[0]);
            return (List)this.currentIterator.next();
        }
        return (List)this.endOfData();
    }

    private boolean moveToNextIterator() {
        if (!this.remainingSegments.isEmpty()) {
            Segment segment = this.remainingSegments.removeFirst();
            this.currentIterator = this.iterate(segment);
            return true;
        }
        return false;
    }

    private CloseableIterator<List<Object>> iterate(Segment segment) {
        if (segment instanceof InlineSegment) {
            return new InlineSegmentIterator((InlineSegment)segment, this.decoder);
        }
        if (segment instanceof SpooledSegment) {
            return new SpooledSegmentIterator((SpooledSegment)segment, this.loader, this.decoder);
        }
        throw new UnsupportedOperationException("Unsupported segment type: " + segment.getClass().getName());
    }

    @Override
    public void close() throws IOException {
        IOException exception = new IOException("Could not close all segments");
        if (this.currentIterator != null) {
            try {
                this.currentIterator.close();
            }
            catch (IOException e) {
                exception.addSuppressed(e);
            }
        }
        for (Segment segment : this.remainingSegments) {
            try {
                this.iterate(segment).close();
            }
            catch (IOException e) {
                exception.addSuppressed(e);
            }
        }
        if (exception.getSuppressed().length > 0) {
            throw exception;
        }
    }

    @Override
    public String toString() {
        return "SegmentsIterator{currentIterator=" + String.valueOf(this.currentIterator) + ", remainingSegments=" + String.valueOf(this.remainingSegments) + "}";
    }
}

