/*
 * Decompiled with CFR 0.152.
 */
package io.trino.jdbc.$internal.client;

import io.trino.jdbc.$internal.client.ClientException;
import io.trino.jdbc.$internal.okhttp3.Interceptor;
import io.trino.jdbc.$internal.okhttp3.Response;
import java.io.IOException;
import java.net.InetAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;

public class DisallowLocalRedirectInterceptor
implements Interceptor {
    @Override
    public Response intercept(Interceptor.Chain chain) throws IOException {
        String location;
        Response response = chain.proceed(chain.request());
        if (response.isRedirect() && !this.redirectAllowed(location = response.header("Location"))) {
            throw new ClientException(String.format("Following redirect to '%s' is disallowed", location));
        }
        return response;
    }

    boolean redirectAllowed(String location) {
        if (location == null) {
            return true;
        }
        try {
            InetAddress[] addresses;
            String host = new URI(location).getHost();
            if (host == null) {
                return true;
            }
            for (InetAddress address : addresses = InetAddress.getAllByName(host)) {
                if (!DisallowLocalRedirectInterceptor.isLocalAddress(address)) continue;
                return false;
            }
        }
        catch (URISyntaxException | UnknownHostException exception) {
            // empty catch block
        }
        return true;
    }

    static boolean isLocalAddress(InetAddress addr) {
        return addr.isAnyLocalAddress() || addr.isLoopbackAddress() || addr.isLinkLocalAddress() || addr.isSiteLocalAddress();
    }
}

