/*
 * Decompiled with CFR 0.152.
 */
package io.trino.jdbc.$internal.client;

import io.trino.jdbc.$internal.client.CloseableIterator;
import io.trino.jdbc.$internal.guava.collect.AbstractIterator;
import java.io.IOException;
import java.util.Objects;

public class CloseableLimitingIterator<T>
extends AbstractIterator<T>
implements CloseableIterator<T> {
    private final long maxRows;
    private final CloseableIterator<T> delegate;
    private long currentRow;

    CloseableLimitingIterator(CloseableIterator<T> delegate, long maxRows) {
        this.delegate = Objects.requireNonNull(delegate, "delegate is null");
        this.maxRows = maxRows;
    }

    @Override
    public void close() throws IOException {
        this.delegate.close();
    }

    @Override
    protected T computeNext() {
        if (this.maxRows > 0L && this.currentRow >= this.maxRows) {
            try {
                this.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return this.endOfData();
        }
        ++this.currentRow;
        if (this.delegate.hasNext()) {
            return (T)this.delegate.next();
        }
        return this.endOfData();
    }

    @Override
    public String toString() {
        return "CloseableLimitingIterator{delegate=" + String.valueOf(this.delegate) + ", maxRows=" + this.maxRows + "}";
    }

    public static <T> CloseableIterator<T> limit(CloseableIterator<T> delegate, long maxRows) {
        return new CloseableLimitingIterator<T>(delegate, maxRows);
    }
}

