/*
 * Decompiled with CFR 0.152.
 */
package io.trino.jdbc.$internal.airlift.compress.v3.zstd;

import io.trino.jdbc.$internal.airlift.compress.v3.hadoop.HadoopInputStream;
import io.trino.jdbc.$internal.airlift.compress.v3.zstd.ZstdInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;

class ZstdHadoopInputStream
extends HadoopInputStream {
    private final InputStream in;
    private ZstdInputStream zstdInputStream;

    public ZstdHadoopInputStream(InputStream in) {
        this.in = Objects.requireNonNull(in, "in is null");
        this.zstdInputStream = new ZstdInputStream(in);
    }

    @Override
    public int read() throws IOException {
        return this.zstdInputStream.read();
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.zstdInputStream.read(b);
    }

    @Override
    public int read(byte[] outputBuffer, int outputOffset, int outputLength) throws IOException {
        return this.zstdInputStream.read(outputBuffer, outputOffset, outputLength);
    }

    @Override
    public void resetState() {
        this.zstdInputStream = new ZstdInputStream(this.in);
    }

    @Override
    public void close() throws IOException {
        this.zstdInputStream.close();
    }
}

