/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.builder.excel.datasource;

import crazydev.iccube.builder.OlapBuilderConnectionPool;
import crazydev.iccube.builder.OlapBuilderContext;
import crazydev.iccube.builder.datasource.reader.OlapBuilderAbstractTableRowReader;
import crazydev.iccube.builder.excel.datasource.OlapBuilderExcelConnection;
import crazydev.iccube.builder.excel.datasource.OlapBuilderExcelDataTable;
import crazydev.iccube.builder.excel.datasource.OlapBuilderExcelTableRow;
import crazydev.iccube.builder.model.def.IOlapBuilderDataTableDef;
import crazydev.iccube.builder.model.def.IOlapBuilderTableRow;
import java.util.Iterator;
import java.util.Map;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.Row;

public class OlapBuilderExcelDataTableRowReader
extends OlapBuilderAbstractTableRowReader<OlapBuilderExcelDataTable, OlapBuilderExcelConnection> {
    private final OlapBuilderExcelConnection myConnection;
    private final int startingPos;
    private Map<String, Integer> columnMapping;
    private Iterator<Row> rowIterator;
    private int rowNum;

    public OlapBuilderExcelDataTableRowReader(OlapBuilderContext context, OlapBuilderConnectionPool connectionPool, int maxRowCount, OlapBuilderExcelDataTable table, int startingPos) {
        super(context, connectionPool, maxRowCount, (IOlapBuilderDataTableDef)table, table.getName());
        this.startingPos = startingPos;
        this.myConnection = null;
    }

    public OlapBuilderExcelDataTableRowReader(OlapBuilderContext context, OlapBuilderConnectionPool connectionPool, int maxRowCount, OlapBuilderExcelDataTable table, OlapBuilderExcelConnection connection, int startingPos) {
        super(context, connectionPool, maxRowCount, (IOlapBuilderDataTableDef)table, table.getName());
        this.myConnection = connection;
        this.startingPos = startingPos;
    }

    public String getSheetName() {
        return ((OlapBuilderExcelDataTable)this.table).getSheetName();
    }

    protected int numberOfHeaderRows() {
        return 1;
    }

    public void doInit() {
        OlapBuilderExcelConnection connection_;
        if (this.myConnection == null) {
            this.initConnection();
            connection_ = (OlapBuilderExcelConnection)this.connection;
        } else {
            connection_ = this.myConnection;
        }
        OlapBuilderExcelConnection.Accessor accesor = connection_.getSheetAccessor(this.getSheetName(), this.startingPos);
        this.rowIterator = accesor.iterator();
        this.columnMapping = ((OlapBuilderExcelDataTable)this.table).createMapping(accesor.getHeaderRow());
        this.rowNum = this.startingPos;
    }

    public boolean isRowSafe() {
        return true;
    }

    public IOlapBuilderTableRow doNextRow() {
        if (!this.rowIterator.hasNext()) {
            return null;
        }
        ++this.rowNum;
        Row row = this.rowIterator.next();
        if (row != null) {
            boolean isEmpty = true;
            Iterator iter = row.cellIterator();
            while (iter.hasNext()) {
                Cell next = (Cell)iter.next();
                if (next.getCellType() == CellType.BLANK) continue;
                isEmpty = false;
                break;
            }
            if (!isEmpty) {
                return new OlapBuilderExcelTableRow((OlapBuilderExcelDataTable)this.table, this.columnMapping, row);
            }
        }
        return null;
    }

    public void done() {
        super.done();
    }
}

