/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.builder.excel.datasource;

import crazydev.common.exception.CdErrorCode;
import crazydev.common.property.CdProperty;
import crazydev.common.property.CdReadProperty;
import crazydev.common.property.CdReadWriteProperty;
import crazydev.iccube.builder.OlapBuilderConnectionPool;
import crazydev.iccube.builder.OlapBuilderContext;
import crazydev.iccube.builder.datasource.reader.IOlapBuilderTableRowReader;
import crazydev.iccube.builder.errors.OlapBuilderErrorManager;
import crazydev.iccube.builder.excel.datasource.OlapBuilderExcelConnection;
import crazydev.iccube.builder.excel.datasource.OlapBuilderExcelDataTableRowReader;
import crazydev.iccube.builder.excel.datasource.OlapBuilderExcelDataTableValidator;
import crazydev.iccube.builder.excel.datasource.OlapBuilderExcelType;
import crazydev.iccube.builder.excel.errors.OlapExcelBuilderErrorCode;
import crazydev.iccube.builder.factory.schema.IOlapBuilderJaxbListener;
import crazydev.iccube.builder.goodies.headerdef.column.OlapBuilderColumnDefinitionParser;
import crazydev.iccube.builder.model.def.IOlapBuilderConnection;
import crazydev.iccube.builder.model.def.IOlapBuilderDataColumnDef;
import crazydev.iccube.builder.model.def.IOlapBuilderDataSource;
import crazydev.iccube.builder.model.def.IOlapBuilderDataTableDef;
import crazydev.iccube.builder.model.impl.OlapBuilderDataColumn;
import crazydev.iccube.builder.model.impl.table.OlapBuilderBaseDataTable;
import crazydev.iccube.builder.model.validation.OlapBuilderValidator;
import crazydev.iccube.builder.type.OlapBuilderInputType;
import crazydev.iccube.olap.component.context.OlapRuntimeContext;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.Row;
import org.jetbrains.annotations.Nullable;

@XmlRootElement(name="excelDataTable")
public class OlapBuilderExcelDataTable
extends OlapBuilderBaseDataTable<OlapBuilderExcelConnection>
implements IOlapBuilderJaxbListener {
    public static final CdProperty SHEET_NAME = new CdReadProperty(OlapBuilderExcelDataTable.class, "sheetName");
    public static final CdProperty START_ROW_NUMBER = new CdReadWriteProperty(OlapBuilderExcelDataTable.class, "headerRowNumber", false);
    public static final CdProperty TRIMSTRINGS = new CdReadWriteProperty(OlapBuilderExcelDataTable.class, "trimStrings");
    public static final CdProperty ADDROWNUMBER = new CdReadWriteProperty(OlapBuilderExcelDataTable.class, "addRowNumber");
    public static final String COL_ROWNUM_NAME = "#RowNumber";
    @XmlAttribute(required=false)
    private String sheetName;
    @XmlAttribute(required=false)
    private boolean trimStrings;
    @XmlAttribute(required=false)
    @Nullable
    private Integer headerRowNumber;
    @XmlAttribute(required=false)
    private boolean addRowNumber;

    public OlapBuilderExcelDataTable() {
    }

    public OlapBuilderExcelDataTable(String sheetName) {
        super(sheetName);
        this.sheetName = sheetName;
    }

    public OlapBuilderExcelDataTable(String sheetName, boolean trimStrings, boolean addRowNumber, List<IOlapBuilderDataColumnDef> columns) {
        super(sheetName, columns);
        this.sheetName = sheetName;
        this.trimStrings = trimStrings;
        this.addRowNumber = addRowNumber;
    }

    public boolean isNameReadOnly() {
        return false;
    }

    public void beforeMarshal() {
    }

    public void afterUnmarshal() {
        if (this.sheetName == null) {
            this.sheetName = this.getName();
        }
    }

    public String getInternalFriendlyTypeName() {
        return "Excel file Table";
    }

    @Nullable
    public Integer getHeaderRowNumber() {
        return this.headerRowNumber;
    }

    protected List<? extends IOlapBuilderDataColumnDef> doDiscoverAllColumns(OlapRuntimeContext context, OlapBuilderExcelConnection openedConnection, OlapBuilderErrorManager errorManager) {
        ArrayList<OlapBuilderDataColumn> columns = new ArrayList<OlapBuilderDataColumn>();
        OlapBuilderExcelConnection.Accessor accessor = openedConnection.getSheetAccessor(this.getSheetName(), this.getActualStartRows());
        if (accessor.isEmptySheet()) {
            errorManager.addError((CdErrorCode)OlapExcelBuilderErrorCode.EXCEL_SHEET_IS_EMPTY, new Serializable[]{this.sheetName});
            return columns;
        }
        Row row = accessor.getHeaderRow();
        int cellCount = row.getPhysicalNumberOfCells();
        if (cellCount == 0) {
            errorManager.addError((CdErrorCode)OlapExcelBuilderErrorCode.EXCEL_SHEET_IS_EMPTY, new Serializable[]{this.sheetName});
            return columns;
        }
        if (this.addRowNumber) {
            columns.add(new OlapBuilderDataColumn(OlapBuilderInputType.INTEGER, "rownum", COL_ROWNUM_NAME));
        }
        block4: for (int col = 0; col < cellCount; ++col) {
            Cell cell = row.getCell(col, Row.MissingCellPolicy.CREATE_NULL_AS_BLANK);
            CellType cellType = cell.getCellType();
            switch (cellType) {
                case BLANK: {
                    continue block4;
                }
                case NUMERIC: 
                case STRING: {
                    String columnName = this.getColumnNameFromCell(cell);
                    if (cellCount == 1 && StringUtils.isBlank((CharSequence)columnName)) {
                        errorManager.addError((CdErrorCode)OlapExcelBuilderErrorCode.EXCEL_SHEET_IS_EMPTY, new Serializable[]{this.sheetName});
                        return columns;
                    }
                    if (StringUtils.isBlank((CharSequence)columnName)) {
                        errorManager.addError((CdErrorCode)OlapExcelBuilderErrorCode.EXCEL_COLUMN_NAME_IS_EMPTY, new Serializable[]{Integer.valueOf(col), this.sheetName});
                        continue block4;
                    }
                    OlapBuilderDataColumn column = OlapBuilderColumnDefinitionParser.getInstance().parse(columnName);
                    OlapBuilderExcelType columnType = this.getColumnType(accessor, col);
                    if (!columnName.contains("<Type.") && column.getType() == OlapBuilderInputType.STRING) {
                        column.setType(columnType.getType());
                    }
                    column.setTableType(columnType.toString());
                    columns.add(column);
                    continue block4;
                }
                default: {
                    errorManager.addError((CdErrorCode)OlapExcelBuilderErrorCode.EXCEL_INCORRECT_CELL_TYPE_FOR_COLUMN, new Serializable[]{this.sheetName, Integer.valueOf(col)});
                }
            }
        }
        return columns;
    }

    protected final String getColumnNameFromCell(Cell cell) {
        String colName = cell.getCellType() == CellType.STRING ? cell.getStringCellValue() : String.valueOf(cell.getNumericCellValue());
        return colName.replace("\n", " ");
    }

    public List<? extends IOlapBuilderDataColumnDef> doDiscoverAllColumnsForRefresh(OlapRuntimeContext context, OlapBuilderExcelConnection connection, OlapBuilderErrorManager errorManager) {
        return this.discoverAllColumns(context, (IOlapBuilderConnection)connection, errorManager);
    }

    private OlapBuilderExcelType getColumnType(OlapBuilderExcelConnection.Accessor sheet, int col) {
        Row row = sheet.getFirstDataRow();
        if (row == null) {
            return OlapBuilderExcelType.EXCEL_UNDEFINED;
        }
        Cell cell = row.getCell(col, Row.MissingCellPolicy.CREATE_NULL_AS_BLANK);
        OlapBuilderExcelType cellType = OlapBuilderExcelDataTable.getCellType(cell);
        switch (cellType) {
            case EXCEL_NUMERIC: {
                return OlapBuilderExcelType.EXCEL_NUMERIC;
            }
            case EXCEL_DATE: {
                return OlapBuilderExcelType.EXCEL_DATE;
            }
            case EXCEL_STRING: {
                return OlapBuilderExcelType.EXCEL_STRING;
            }
            case EXCEL_BOOLEAN: {
                return OlapBuilderExcelType.EXCEL_BOOLEAN;
            }
            case EXCEL_BLANK: 
            case EXCEL_UNDEFINED: {
                return OlapBuilderExcelType.EXCEL_UNDEFINED;
            }
        }
        return OlapBuilderExcelType.EXCEL_UNDEFINED;
    }

    protected IOlapBuilderTableRowReader<OlapBuilderExcelConnection> doCreateFullTableRowReader(OlapBuilderContext context, OlapBuilderConnectionPool connectionPool, int maxRowCount) {
        return new OlapBuilderExcelDataTableRowReader(context, connectionPool, maxRowCount, this, this.getActualStartRows());
    }

    public OlapBuilderExcelDataTableRowReader createFullTableRowReaderForGoogle(OlapBuilderContext context, OlapBuilderConnectionPool connectionPool, int maxRowCount, OlapBuilderExcelConnection connection) {
        return new OlapBuilderExcelDataTableRowReader(context, connectionPool, maxRowCount, this, connection, this.getActualStartRows());
    }

    private int getActualStartRows() {
        return this.headerRowNumber == null ? 0 : Math.max(0, this.headerRowNumber - 1);
    }

    protected Map<String, Integer> createMapping(Row row) {
        HashMap<String, Integer> columnMapping = new HashMap<String, Integer>();
        int cellCount = row == null ? 0 : row.getPhysicalNumberOfCells();
        for (int col = 0; col < cellCount; ++col) {
            Cell cell = row.getCell(col, Row.MissingCellPolicy.CREATE_NULL_AS_BLANK);
            String columnName = this.getColumnNameFromCell(cell);
            OlapBuilderDataColumn column = OlapBuilderColumnDefinitionParser.getInstance().parse(columnName);
            IOlapBuilderDataColumnDef columnDef = this.lookupSelectedColumn(column.getName());
            if (columnDef == null) continue;
            columnMapping.put(columnDef.getName(), col);
        }
        return columnMapping;
    }

    public static OlapBuilderExcelType getCellType(Cell cell) {
        return OlapBuilderExcelDataTable.getICellType(cell, cell.getCellType(), false);
    }

    public static boolean isDateCell(Cell cell) {
        try {
            return DateUtil.isCellDateFormatted((Cell)cell);
        }
        catch (RuntimeException ignored) {
            return false;
        }
    }

    private static OlapBuilderExcelType getICellType(Cell cell, CellType cellType, boolean rec) {
        switch (cellType) {
            case NUMERIC: {
                boolean isDate = OlapBuilderExcelDataTable.isDateCell(cell);
                return isDate ? OlapBuilderExcelType.EXCEL_DATE : OlapBuilderExcelType.EXCEL_NUMERIC;
            }
            case BOOLEAN: {
                return OlapBuilderExcelType.EXCEL_BOOLEAN;
            }
            case STRING: {
                return OlapBuilderExcelType.EXCEL_STRING;
            }
            case FORMULA: {
                if (rec) {
                    return OlapBuilderExcelType.EXCEL_UNDEFINED;
                }
                return OlapBuilderExcelDataTable.getICellType(cell, cell.getCachedFormulaResultType(), true);
            }
            case BLANK: {
                return OlapBuilderExcelType.EXCEL_BLANK;
            }
        }
        return OlapBuilderExcelType.EXCEL_UNDEFINED;
    }

    public OlapBuilderValidator<IOlapBuilderDataSource<OlapBuilderExcelConnection>, IOlapBuilderDataTableDef<OlapBuilderExcelConnection>> getValidator() {
        return new OlapBuilderExcelDataTableValidator();
    }

    public boolean getTrimStrings() {
        return this.trimStrings;
    }

    @Nullable
    protected IOlapBuilderTableRowReader createRowReaderForTableCacheRead(OlapBuilderContext context) {
        return null;
    }

    protected IOlapBuilderTableRowReader decorateRowReaderForTableCache(OlapBuilderContext context, IOlapBuilderTableRowReader reader) {
        return reader;
    }

    public String getSheetName() {
        return this.sheetName;
    }
}

