/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.builder.excel.datasource;

import crazydev.common.collection.CdFilter;
import crazydev.common.property.CdProperty;
import crazydev.common.property.CdReadWriteProperty;
import crazydev.iccube.builder.excel.datasource.OlapBuilderExcelConnection;
import crazydev.iccube.builder.excel.datasource.OlapBuilderExcelDataSourceValidator;
import crazydev.iccube.builder.excel.datasource.OlapBuilderExcelDataTable;
import crazydev.iccube.builder.model.def.IOlapBuilderDataSource;
import crazydev.iccube.builder.model.def.IOlapBuilderTabularDataDef;
import crazydev.iccube.builder.model.def.IOlapBuilderValidationEnabled;
import crazydev.iccube.builder.model.impl.OlapBuilderBaseDataSource;
import crazydev.iccube.builder.model.impl.table.OlapBuilderBaseDataTable;
import crazydev.iccube.builder.model.validation.OlapBuilderValidator;
import crazydev.iccube.builder.ux.meta.common.wizard.UxBuilderWizardStep;
import crazydev.iccube.builder.ux.meta.common.wizard.UxBuilderWizardValidation;
import crazydev.iccube.builder.ux.meta.datasource.UxBuilderDataSourceType;
import crazydev.iccube.builder.ux.meta.datasource.UxBuilderDataSourceTypeGroupId;
import crazydev.iccube.builder.ux.meta.datasource.wizard.UxBuilderCreateDataSourceWizardSteps;
import crazydev.iccube.builder.ux.meta.datasource.wizard.UxBuilderCreateTypedDataSourceWizard;
import crazydev.iccube.builder.ux.meta.datasource.wizard.UxBuilderDataSourceNameForm;
import crazydev.iccube.fs.OlapFileSystem;
import crazydev.iccube.olap.component.context.OlapRuntimeContext;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;

@XmlRootElement(name="excelDS")
public class OlapBuilderExcelDataSource
extends OlapBuilderBaseDataSource<OlapBuilderExcelConnection> {
    public static final CdProperty FILE = new CdReadWriteProperty(OlapBuilderExcelDataSource.class, "excelFile"){

        public Class<?> getTypeForDefaultEditor() {
            return File.class;
        }
    };
    public static final CdProperty WITHOUT_FORMULAS = new CdReadWriteProperty(OlapBuilderExcelDataSource.class, "excelWithoutFormulas");
    @XmlElement(name="excelFileName", required=true)
    private String excelFile;
    @XmlAttribute(name="excelWithoutFormulas", required=false)
    private boolean excelWithoutFormulas;

    public OlapBuilderExcelDataSource() {
        this.excelWithoutFormulas = true;
    }

    public OlapBuilderExcelDataSource(String excelFileName) {
        this(null, excelFileName);
    }

    public OlapBuilderExcelDataSource(@Nullable File xmlFile, String excelFile) {
        super(excelFile);
        this.excelFile = excelFile;
        this.setXmlFile(xmlFile);
    }

    public UxBuilderDataSourceTypeGroupId getUxGroupId() {
        return UxBuilderDataSourceTypeGroupId.dsTypeGroupFiles;
    }

    protected String getReportDataSourceType() {
        return "excel";
    }

    protected String getReportDataSourceTypeCaption() {
        return "Excel";
    }

    public boolean isDiscoverTablesSupported() {
        return true;
    }

    @Nullable
    public List<Class<? extends IOlapBuilderTabularDataDef>> getCreatedTableTypes() {
        return null;
    }

    public OlapBuilderExcelConnection createConnection(OlapRuntimeContext context, boolean forceRefresh) {
        OlapFileSystem fs = context.getRootFileSystem();
        String d = fs.evalPropertyForCubesLocation(this.excelFile);
        return new OlapBuilderExcelConnection(this, d, this.excelWithoutFormulas);
    }

    public OlapBuilderBaseDataTable<OlapBuilderExcelConnection> createEmptyDiscoverTable(String tableName) {
        return new OlapBuilderExcelDataTable(tableName);
    }

    public String getExcelFile() {
        return this.excelFile;
    }

    public OlapBuilderValidator<IOlapBuilderValidationEnabled, IOlapBuilderDataSource> getValidator() {
        return new OlapBuilderExcelDataSourceValidator();
    }

    public List<String> discoverAllTablesNames(OlapBuilderExcelConnection openedConnection, boolean filterSystemSchemas, @Nullable String filter) {
        CdFilter cdFilter = sheetName -> this.acceptTableNameForDiscoverTableNames(filter, (String)sheetName);
        List<String> sheetNames = openedConnection.getSheetNames((CdFilter<String>)cdFilter);
        return sheetNames;
    }

    public boolean acceptCachedTable() {
        return false;
    }

    public boolean isWithoutFormulas() {
        return this.excelWithoutFormulas;
    }

    protected UxBuilderDataSourceType createUxType() {
        String id = this.getTypeId();
        return new UxBuilderDataSourceType(id, this.getUxTypeImage(), () -> new UxBuilderCreateTypedDataSourceWizard(this, id, this.createUxCreateWizardSteps()){
            {
                Objects.requireNonNull(this$0);
                super(arg0, arg1);
            }

            public UxBuilderWizardValidation validate(OlapRuntimeContext context, int activeStep) {
                UxBuilderDataSourceNameForm name = (UxBuilderDataSourceNameForm)((UxBuilderWizardStep)this.steps.get(0)).getModel();
                OlapBuilderExcelDataSource props = (OlapBuilderExcelDataSource)((Object)((UxBuilderWizardStep)this.steps.get(1)).getModel());
                props.setNameAndDescription(name.getName(), name.getDescription());
                try (OlapBuilderExcelConnection conn = null;){
                    conn = props.createConnection(context, true);
                    conn.openForCheckConnection(context);
                    UxBuilderWizardValidation uxBuilderWizardValidation = new UxBuilderWizardValidation(activeStep);
                    return uxBuilderWizardValidation;
                }
            }
        });
    }

    protected List<UxBuilderWizardStep> createUxCreateWizardSteps() {
        ArrayList<UxBuilderWizardStep> steps = new ArrayList<UxBuilderWizardStep>();
        steps.add(UxBuilderCreateDataSourceWizardSteps.name());
        steps.add(UxBuilderCreateDataSourceWizardSteps.propsExclude((boolean)true, (Object)this.createEmptyDataSource(), (CdProperty[])new CdProperty[]{NAME, DESCRIPTION}));
        return steps;
    }
}

