/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.builder.excel.datasource;

import com.github.pjfanning.xlsx.StreamingReader;
import crazydev.common.collection.CdFilter;
import crazydev.common.exception.programming.CdShouldNotBeHereProgrammingException;
import crazydev.iccube.builder.datasource.OlapBuilderAbstractConnection;
import crazydev.iccube.builder.errors.OlapBuilderErrorCode;
import crazydev.iccube.builder.errors.OlapBuilderErrorException;
import crazydev.iccube.builder.excel.datasource.OlapBuilderExcelDataSource;
import crazydev.iccube.builder.excel.datasource.OlapBuilderExcelDataTable;
import crazydev.iccube.builder.excel.errors.OlapExcelBuilderErrorCode;
import crazydev.iccube.builder.model.impl.OlapBuilderBaseDataSource;
import crazydev.iccube.fs.OlapFile;
import crazydev.iccube.fs.OlapFileSystem;
import crazydev.iccube.olap.component.context.OlapRuntimeContext;
import crazydev.iccube.olap.loggers.OlapLoggers;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.jetbrains.annotations.Nullable;

public class OlapBuilderExcelConnection
extends OlapBuilderAbstractConnection<OlapBuilderExcelDataSource> {
    private final String untrustedExcelFile;
    private final boolean dontUseStream;
    protected Workbook workbook;

    public OlapBuilderExcelConnection(OlapBuilderExcelDataSource dataSource, String untrustedExcelFile, boolean withoutFormulas) {
        super((OlapBuilderBaseDataSource)dataSource);
        this.untrustedExcelFile = untrustedExcelFile;
        this.dontUseStream = !withoutFormulas;
    }

    public static OlapBuilderExcelConnection openFromInputStream(InputStream content, String fileName, boolean withoutFormulas) {
        OlapBuilderExcelConnection connection = new OlapBuilderExcelConnection(new OlapBuilderExcelDataSource(), fileName, withoutFormulas);
        connection.createWorkbook(() -> content, null, connection.untrustedExcelFile);
        connection.forceIsOpen();
        return connection;
    }

    public void onOpen(OlapRuntimeContext context) throws OlapBuilderErrorException {
        OlapFileSystem fs = context.getRootFileSystem();
        OlapFile trusted = fs.create(this.untrustedExcelFile);
        OlapLoggers.BUILDER.info((Object)("[excel] opening [stream:" + !this.dontUseStream + "] [" + this.untrustedExcelFile + "]"));
        this.createWorkbook(() -> ((OlapFile)trusted).createInputStream(), trusted.__getUnderlying(), trusted.getUnderlyingAbsolutePathForUserError());
    }

    public boolean isInvalid() {
        return !this.dontUseStream;
    }

    private void createWorkbook(MySupplier<InputStream> inputStream, @Nullable File file, String fileNameForUser) {
        try {
            if (!this.dontUseStream) {
                try {
                    this.workbook = StreamingReader.builder().rowCacheSize(100).bufferSize(4096).open(inputStream.get());
                    return;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.workbook = file != null ? WorkbookFactory.create((File)file) : WorkbookFactory.create((InputStream)inputStream.get());
        }
        catch (FileNotFoundException ex) {
            throw new OlapBuilderErrorException((Throwable)ex, (OlapBuilderErrorCode)OlapExcelBuilderErrorCode.EXCEL_FILE_NOT_FOUND, new Serializable[]{fileNameForUser, ex.getMessage()});
        }
        catch (IOException ex) {
            throw new OlapBuilderErrorException((Throwable)ex, (OlapBuilderErrorCode)OlapExcelBuilderErrorCode.EXCEL_FILE_READING_ERROR, new Serializable[]{fileNameForUser, ex.getMessage()});
        }
        catch (IllegalArgumentException ex) {
            throw new OlapBuilderErrorException((Throwable)ex, (OlapBuilderErrorCode)OlapExcelBuilderErrorCode.EXCEL_FILE_INCORRECT_CONTENT, new Serializable[]{fileNameForUser, ex.getMessage()});
        }
    }

    protected void onClose() {
        if (this.workbook != null) {
            try {
                this.workbook.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.workbook = null;
    }

    public Workbook _getWorkbook() {
        this.assertIsOpen();
        return this.workbook;
    }

    private Sheet getSheet(String sheetName) {
        this.assertIsOpen();
        Sheet sheet = this.workbook.getSheet(sheetName);
        if (sheet == null) {
            throw new OlapBuilderErrorException((OlapBuilderErrorCode)OlapExcelBuilderErrorCode.EXCEL_SHEET_NOT_FOUND, new Serializable[]{sheetName, this.untrustedExcelFile});
        }
        return sheet;
    }

    @Nullable
    public Sheet getSheet(OlapBuilderExcelDataTable dataTable) {
        return this.getSheet(dataTable.getSheetName());
    }

    public List<String> getSheetNames(CdFilter<String> filter) {
        ArrayList<String> dataTables = new ArrayList<String>();
        for (Sheet sheet : this.workbook) {
            String sheetName = sheet.getSheetName();
            if (!filter.accept((Object)sheetName)) continue;
            dataTables.add(sheetName);
        }
        return dataTables;
    }

    public Accessor getSheetAccessor(String sheetName, int headerRowIdx) {
        this.assertIsOpen();
        return new Accessor(this.getSheet(sheetName), headerRowIdx);
    }

    public void checkSheetExists(String sheetName) {
        this.assertIsOpen();
        if (this.getSheetNames((CdFilter<String>)((CdFilter)sheetName::equals)).isEmpty()) {
            throw new OlapBuilderErrorException((OlapBuilderErrorCode)OlapExcelBuilderErrorCode.EXCEL_SHEET_NOT_FOUND, new Serializable[]{sheetName});
        }
    }

    @FunctionalInterface
    public static interface MySupplier<T> {
        public T get() throws IOException;
    }

    static class Accessor {
        private final Iterator<Row> iter;
        private final Row headerRow;
        private final Row firstDataRow;

        Accessor(Sheet sheet, Integer headerRowIdx) {
            this.iter = sheet.iterator();
            this.headerRow = this.getHeaderRow(headerRowIdx);
            this.firstDataRow = this.iter.hasNext() ? this.iter.next() : null;
        }

        boolean isEmptySheet() {
            return this.headerRow == null;
        }

        private Row getHeaderRow(Integer headerRowIdx) {
            int count = 0;
            while (this.iter.hasNext()) {
                Row row = this.iter.next();
                if (row == null) {
                    throw new CdShouldNotBeHereProgrammingException();
                }
                if (headerRowIdx != count++) continue;
                return row;
            }
            return null;
        }

        public Row getHeaderRow() {
            return this.headerRow;
        }

        public Row getFirstDataRow() {
            return this.firstDataRow;
        }

        Iterator<Row> iterator() {
            return new Iterator<Row>(this){
                boolean gotFirst;
                final /* synthetic */ Accessor this$0;
                {
                    Accessor accessor = this$0;
                    Objects.requireNonNull(accessor);
                    this.this$0 = accessor;
                    this.gotFirst = false;
                }

                @Override
                public boolean hasNext() {
                    return this.gotFirst ? this.this$0.iter.hasNext() : this.this$0.firstDataRow != null;
                }

                @Override
                public Row next() {
                    if (this.gotFirst) {
                        return this.this$0.iter.next();
                    }
                    this.gotFirst = true;
                    return this.this$0.firstDataRow;
                }
            };
        }
    }
}

