/*
 * Decompiled with CFR 0.152.
 */
package crazydev.common.xml;

import crazydev.common.configuration.CdConfigurationUtils;
import crazydev.common.exception.CdRuntimeException;
import crazydev.common.utils.CdIoUtils;
import crazydev.common.xml.CdXmlMarshallerListeners;
import crazydev.common.xml.CdXmlSerializable;
import crazydev.common.xml.CdXmlUnmarshallerListeners;
import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBElement;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.Marshaller;
import jakarta.xml.bind.Unmarshaller;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.util.Arrays;
import java.util.concurrent.ConcurrentHashMap;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.apache.logging.log4j.core.util.IOUtils;
import org.apache.xerces.util.XMLChar;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public abstract class CdXmlUtils {
    private static final ConcurrentHashMap<ContextKey, Unmarshaller> unmarshallers = new ConcurrentHashMap();
    private static final CdXmlUnmarshallerListeners unmarshallerListeners = new CdXmlUnmarshallerListeners();
    private static final ConcurrentHashMap<ContextKey, Marshaller> marshallers = new ConcurrentHashMap();
    private static final CdXmlMarshallerListeners marshallerListeners = new CdXmlMarshallerListeners();

    public static String getJAXBMessage(JAXBException ex) {
        Throwable linkedException = ex.getLinkedException();
        Object message = linkedException == null ? ex.getMessage() : "XML error : " + linkedException.getMessage();
        return message;
    }

    public static String escapeForTagName(String value) {
        StringBuffer sb = new StringBuffer();
        for (int idx = 0; idx < value.length(); ++idx) {
            char ch = value.charAt(idx);
            if (!XMLChar.isName((int)ch)) {
                String hex = Integer.toHexString(ch).toUpperCase();
                sb.append("_x");
                for (int tt = 0; tt < 4 - hex.length(); ++tt) {
                    sb.append("0");
                }
                sb.append(hex);
                sb.append("_");
                continue;
            }
            sb.append(ch);
        }
        return sb.toString();
    }

    public static String getNamespaceAlias(String namespace, Node element) {
        NamedNodeMap attributes = element.getAttributes();
        for (int i = 0; i < attributes.getLength(); ++i) {
            Node attribute = attributes.item(i);
            if (!attribute.getNodeValue().equals(namespace)) continue;
            return attribute.getLocalName();
        }
        throw new CdRuntimeException("Namespace doesn't supported");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T unmarshall(boolean substVars, String charset, File xmlFile, Class ... classes) throws JAXBException, IOException {
        InputStream in = CdIoUtils.createInputStreamBOM(xmlFile, charset);
        BufferedReader reader = new BufferedReader(new InputStreamReader(in, charset));
        if (substVars) {
            try {
                T bean;
                String conf = IOUtils.toString((Reader)reader);
                String confS = CdConfigurationUtils.substVars(conf);
                T t = bean = CdXmlUtils.unmarshall(xmlFile, new StringReader(confS), classes);
                return t;
            }
            finally {
                CdIoUtils.closeQuietly(reader);
            }
        }
        T bean = CdXmlUtils.unmarshall(xmlFile, reader, classes);
        return bean;
    }

    public static <T> T unmarshall(String charset, File xmlFile, Class ... classes) throws JAXBException, IOException {
        InputStream in = CdIoUtils.createInputStreamBOM(xmlFile, charset);
        BufferedReader reader = new BufferedReader(new InputStreamReader(in, charset));
        return CdXmlUtils.unmarshall(xmlFile, reader, classes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T unmarshall(@Nullable File xmlFile, Reader xml, Class ... classes) throws JAXBException {
        Object item = null;
        try {
            Unmarshaller unmarshaller;
            Object object = unmarshaller = CdXmlUtils.setupJAXBUnmarshaller(classes);
            synchronized (object) {
                item = unmarshaller.unmarshal(xml);
            }
            object = item;
            return (T)object;
        }
        finally {
            if (item != null && xmlFile != null && item instanceof CdXmlSerializable) {
                ((CdXmlSerializable)item).setXmlFile(xmlFile);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static <T> T unmarshall(@Nullable String xml, Class ... classes) throws JAXBException {
        Unmarshaller unmarshaller;
        if (StringUtils.isEmpty((CharSequence)xml)) {
            return null;
        }
        Unmarshaller unmarshaller2 = unmarshaller = CdXmlUtils.setupJAXBUnmarshaller(classes);
        synchronized (unmarshaller2) {
            Object item = unmarshaller.unmarshal((Reader)new StringReader(xml));
            return (T)item;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static <T> T unmarshall(@Nullable Node xml, Class<T> clazz) throws JAXBException {
        Unmarshaller unmarshaller;
        if (xml == null) {
            return null;
        }
        Unmarshaller unmarshaller2 = unmarshaller = CdXmlUtils.setupJAXBUnmarshaller(clazz);
        synchronized (unmarshaller2) {
            JAXBElement element = unmarshaller.unmarshal((Source)new DOMSource(xml), clazz);
            Object item = element.getValue();
            return (T)item;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> void marshall(Writer writer, T item, Class ... classes) throws JAXBException {
        Marshaller marshaller;
        Marshaller marshaller2 = marshaller = CdXmlUtils.setupJAXBMarshaller(classes);
        synchronized (marshaller2) {
            marshaller.marshal(item, writer);
        }
    }

    public static void addUnmarshallerListener(Unmarshaller.Listener listener) {
        unmarshallerListeners.add(listener);
    }

    public static void addMarshallerListener(Marshaller.Listener listener) {
        marshallerListeners.add(listener);
    }

    public static void resetJAXBMarshaller(Class ... classes) throws JAXBException {
        try {
            ContextKey key = new ContextKey(classes);
            JAXBContext context = JAXBContext.newInstance((Class[])classes);
            Marshaller marshaller = context.createMarshaller();
            marshaller.setProperty("jaxb.formatted.output", (Object)true);
            marshaller.setListener((Marshaller.Listener)marshallerListeners);
            marshallers.put(key, marshaller);
        }
        catch (JAXBException ex) {
            Logger GENERAL = Logger.getLogger((String)"icCube.general");
            GENERAL.error((Object)("[XML] JAXB (marshall) errors : " + String.valueOf((Object)ex)));
            GENERAL.error((Object)"[XML] JAXB (marshall) error", (Throwable)ex);
            throw ex;
        }
    }

    public static Marshaller setupJAXBMarshaller(Class ... classes) throws JAXBException {
        ContextKey key = new ContextKey(classes);
        try {
            return marshallers.computeIfAbsent(key, k -> {
                try {
                    JAXBContext context = JAXBContext.newInstance((Class[])classes);
                    Marshaller marshaller = context.createMarshaller();
                    marshaller.setProperty("jaxb.formatted.output", (Object)true);
                    marshaller.setListener((Marshaller.Listener)marshallerListeners);
                    return marshaller;
                }
                catch (JAXBException e) {
                    throw new RuntimeException(e);
                }
            });
        }
        catch (RuntimeException ex) {
            Throwable cause = ex.getCause();
            if (cause instanceof JAXBException) {
                throw (JAXBException)cause;
            }
            throw ex;
        }
    }

    public static void resetJAXBUnmarshaller(Class ... classes) throws JAXBException {
        try {
            ContextKey key = new ContextKey(classes);
            JAXBContext context = JAXBContext.newInstance((Class[])classes);
            Unmarshaller unmarshaller = context.createUnmarshaller();
            unmarshaller.setEventHandler(event -> false);
            unmarshaller.setListener((Unmarshaller.Listener)unmarshallerListeners);
            unmarshallers.put(key, unmarshaller);
        }
        catch (JAXBException ex) {
            Logger GENERAL = Logger.getLogger((String)"icCube.general");
            GENERAL.error((Object)("[XML] JAXB (unmarshall) errors : " + String.valueOf((Object)ex)));
            GENERAL.error((Object)"[XML] JAXB (unmarshall) error", (Throwable)ex);
            throw ex;
        }
    }

    public static Unmarshaller setupJAXBUnmarshaller(Class ... classes) throws JAXBException {
        ContextKey key = new ContextKey(classes);
        try {
            return unmarshallers.computeIfAbsent(key, k -> {
                try {
                    JAXBContext context = JAXBContext.newInstance((Class[])classes);
                    Unmarshaller unmarshaller = context.createUnmarshaller();
                    unmarshaller.setEventHandler(event -> false);
                    unmarshaller.setListener((Unmarshaller.Listener)unmarshallerListeners);
                    return unmarshaller;
                }
                catch (JAXBException ex) {
                    Logger GENERAL = Logger.getLogger((String)"icCube.general");
                    GENERAL.error((Object)("[XML] JAXB errors : " + String.valueOf((Object)ex)));
                    GENERAL.error((Object)"[XML] JAXB error", (Throwable)ex);
                    throw new RuntimeException(ex);
                }
            });
        }
        catch (RuntimeException ex) {
            Throwable cause = ex.getCause();
            if (cause instanceof JAXBException) {
                throw (JAXBException)cause;
            }
            throw ex;
        }
    }

    private static class ContextKey {
        private final Class[] classes;

        public ContextKey(Class[] classes) {
            this.classes = classes;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ContextKey that = (ContextKey)o;
            return Arrays.equals(this.classes, that.classes);
        }

        public int hashCode() {
            return Arrays.hashCode(this.classes);
        }
    }
}

