/*
 * Decompiled with CFR 0.152.
 */
package crazydev.common.xml;

import crazydev.common.exception.programming.CdProgrammingException;
import crazydev.common.utils.CdClassUtils;
import jakarta.xml.bind.annotation.XmlEnum;
import jakarta.xml.bind.annotation.XmlTransient;
import java.io.File;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.jetbrains.annotations.Nullable;
import org.joda.time.LocalDateTime;

public class CdXmlFieldNavigator {
    private static final ArrayList<Class> knownTypes = new ArrayList();

    public static boolean xmlEquals(Object item1, Object item2) {
        final MutableBoolean bool = new MutableBoolean(true);
        Navigator nav = new Navigator(){

            @Override
            public void onFieldsDifferent(Object item1, Object item2, String s) {
                bool.setValue(false);
            }
        };
        CdXmlFieldNavigator.xmlEquals(item1, item2, nav);
        return bool.booleanValue();
    }

    private static void xmlEquals(Object item1, Object item2, Navigator inspector) {
        inspector.onBegin(item1);
        try {
            if (item1 == null || item2 == null) {
                if (item1 != item2) {
                    inspector.onFieldsDifferent(item1, item2, "Not both null");
                }
            } else if (item1 instanceof Iterable && item2 instanceof Iterable) {
                Iterable collection = (Iterable)item1;
                Iterator iter2 = ((Iterable)item2).iterator();
                for (Object subItem : collection) {
                    if (!iter2.hasNext()) {
                        inspector.onFieldsDifferent(item1, item2, "Different Values");
                        break;
                    }
                    CdXmlFieldNavigator.xmlEquals(subItem, iter2.next(), inspector);
                }
                if (iter2.hasNext()) {
                    inspector.onFieldsDifferent(item1, item2, "Not the same size");
                }
            } else if (item1.getClass() != item2.getClass()) {
                inspector.onFieldsDifferent(item1, item2, "Different classes");
            } else if (item1.getClass().isPrimitive() || item1.getClass().isEnum() || item1.getClass().getSuperclass().isEnum() || CdXmlFieldNavigator.knownTypesContains(item1)) {
                if (!item1.equals(item2)) {
                    inspector.onFieldsDifferent(item1, item2, "Different Values");
                }
            } else {
                CdXmlFieldNavigator.checkFields(item1, item2, inspector);
            }
        }
        catch (IllegalAccessException ex) {
            throw new CdProgrammingException("Unexpected ", ex);
        }
        finally {
            inspector.onEnd(item1);
        }
    }

    private static void checkFields(Object item1, Object item2, Navigator inspector) throws IllegalAccessException {
        List<Field> fields = CdClassUtils.getAllDeclaredFields(item1.getClass());
        for (Field field : fields) {
            if (Modifier.isStatic(field.getModifiers()) || field.getDeclaringClass().equals(Enum.class)) continue;
            if (field.getAnnotations().length == 0) {
                throw new CdProgrammingException("Class [" + String.valueOf(item1.getClass()) + "] field [" + String.valueOf(field) + "] should be annotated !");
            }
            if (field.getAnnotation(XmlTransient.class) != null) continue;
            field.setAccessible(true);
            Object fieldValueForItem1 = field.get(item1);
            Object fieldValueForItem2 = field.get(item2);
            CdXmlFieldNavigator.xmlEquals(fieldValueForItem1, fieldValueForItem2, inspector);
        }
    }

    public static void navigate(Object item, Navigator inspector) {
        inspector.onBegin(item);
        try {
            if (item == null) {
                inspector.onNull();
            } else if (item.getClass().isPrimitive() || CdXmlFieldNavigator.knownTypesContains(item)) {
                inspector.onPrimitiveType(item);
            } else if (item instanceof Iterable) {
                Iterable collection = (Iterable)item;
                for (Object subItem : collection) {
                    CdXmlFieldNavigator.navigate(subItem, inspector);
                }
            } else {
                List<Field> fields = CdClassUtils.getAllDeclaredFields(item.getClass());
                for (Field field : fields) {
                    if (Modifier.isStatic(field.getModifiers())) continue;
                    if (field.getType().isEnum()) {
                        if (field.getType().getAnnotation(XmlEnum.class) != null) continue;
                        throw new CdProgrammingException("Enum [" + String.valueOf(field.getType()) + "] class should be annotated with XmlEnum");
                    }
                    if (field.getAnnotations().length == 0) {
                        throw new CdProgrammingException("Class [" + String.valueOf(item.getClass()) + "] field [" + String.valueOf(field) + "] should be annotated !");
                    }
                    if (field.getAnnotation(XmlTransient.class) != null) continue;
                    field.setAccessible(true);
                    Object fieldValue = field.get(item);
                    CdXmlFieldNavigator.navigate(fieldValue, inspector);
                }
            }
        }
        catch (IllegalAccessException ex) {
            throw new CdProgrammingException("Unexpected ", ex);
        }
        finally {
            inspector.onEnd(item);
        }
    }

    private static boolean knownTypesContains(Object item) {
        if (item instanceof File) {
            return knownTypes.contains(item.getClass());
        }
        return knownTypes.contains(item.getClass());
    }

    static {
        knownTypes.add(File.class);
        knownTypes.add(String.class);
        knownTypes.add(Integer.class);
        knownTypes.add(Long.class);
        knownTypes.add(Boolean.class);
        knownTypes.add(LocalDateTime.class);
        knownTypes.add(Locale.class);
        knownTypes.add(Map.class);
        knownTypes.add(HashMap.class);
    }

    public static class Navigator {
        protected int count = 0;

        public void onEnd(@Nullable Object item) {
            --this.count;
        }

        public void onBegin(@Nullable Object item) {
            ++this.count;
        }

        public void onPrimitiveType(Object fieldValue) {
        }

        public void onNull() {
        }

        public void onFieldsDifferent(Object item1, Object item2, String s) {
        }
    }
}

