/*
 * Decompiled with CFR 0.152.
 */
package crazydev.common.utils;

import crazydev.common.utils.CdStringUtils;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import java.util.Date;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import org.jetbrains.annotations.Nullable;
import org.joda.time.ReadablePartial;

public abstract class CdTimeUtils {
    private static final Pattern pattern = Pattern.compile("[0-9]{4}[-][0-9]{2}[-][0-9]{2}[T][0-9]{2}[:][0-9]{2}[:][0-9]{2}.*");

    public static String formatNanos(long nanos) {
        if (nanos < 1000L) {
            return String.format("%dns", nanos);
        }
        if (nanos < 10000L) {
            return String.format("%.2fus", (double)nanos / 1000.0);
        }
        if (nanos < 1000000L) {
            return String.format("%dus", nanos / 1000L);
        }
        if (nanos < 10000000L) {
            return String.format("%.2fms", (double)nanos / 1000.0 / 1000.0);
        }
        if (nanos < 1000000000L) {
            return String.format("%dms", nanos / 1000L / 1000L);
        }
        return CdTimeUtils.formatMillis(nanos / 1000L / 1000L);
    }

    public static String formatNanosEx(long startNanos) {
        return CdTimeUtils.formatNanos(System.nanoTime() - startNanos);
    }

    public static String formatMillis(long millis) {
        return CdTimeUtils.formatMillis(null, millis);
    }

    public static String formatMillis(@Nullable Locale locale, long millis) {
        return CdTimeUtils.formatMillis(locale, "", millis);
    }

    public static String formatMillis(@Nullable Locale locale, String separator, long millis) {
        if (millis < 10000L) {
            return String.format(locale, "%,dms", millis);
        }
        if (millis < 60000L) {
            return String.format(locale, "%.2fs", (double)millis / 1000.0);
        }
        long days = TimeUnit.MILLISECONDS.toDays(millis);
        long hours = TimeUnit.MILLISECONDS.toHours(millis -= TimeUnit.DAYS.toMillis(days));
        long minutes = TimeUnit.MILLISECONDS.toMinutes(millis -= TimeUnit.HOURS.toMillis(hours));
        long seconds = TimeUnit.MILLISECONDS.toSeconds(millis -= TimeUnit.MINUTES.toMillis(minutes));
        if (days != 0L) {
            return String.format(locale, "%dd" + separator + "%02dh" + separator + "%02dm" + separator + "%02ds", days, hours, minutes, seconds);
        }
        if (hours != 0L) {
            return String.format(locale, "%dh" + separator + "%02dm" + separator + "%02ds", hours, minutes, seconds);
        }
        return String.format(locale, "%dm" + separator + "%02ds", minutes, seconds);
    }

    public static double[] formatMillisA(long millis) {
        if (millis < 10000L) {
            return new double[]{-millis};
        }
        if (millis < 60000L) {
            return new double[]{(double)millis / 1000.0};
        }
        long days = TimeUnit.MILLISECONDS.toDays(millis);
        long hours = TimeUnit.MILLISECONDS.toHours(millis -= TimeUnit.DAYS.toMillis(days));
        long minutes = TimeUnit.MILLISECONDS.toMinutes(millis -= TimeUnit.HOURS.toMillis(hours));
        long seconds = TimeUnit.MILLISECONDS.toSeconds(millis -= TimeUnit.MINUTES.toMillis(minutes));
        if (days != 0L) {
            return new double[]{days, hours, minutes, seconds};
        }
        if (hours != 0L) {
            return new double[]{hours, minutes, seconds};
        }
        return new double[]{minutes, seconds};
    }

    public static String formatMillisEx(long startMillis) {
        return CdTimeUtils.formatMillis(System.currentTimeMillis() - startMillis);
    }

    public static String format(Date start, @Nullable Date end) {
        if (end == null) {
            return "";
        }
        return CdTimeUtils.formatMillis(end.getTime() - start.getTime());
    }

    public static boolean mightbeISOJsDate(@Nullable String asString) {
        return asString != null && pattern.matcher(asString).matches();
    }

    public static String formatServerTime(Date time) {
        return new SimpleDateFormat("dd-MMM-yyyy HH:mm:ss z").format(time);
    }

    public static String formatServerTimeForRequest(Date time) {
        SimpleDateFormat df = new SimpleDateFormat("dd-MM-yy HH:mm:ss zzz");
        return df.format(time);
    }

    public static String formatServerTimeForJavascript(Date time) {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss.SSSXXX").withZone(ZoneId.systemDefault());
        return formatter.format(time.toInstant());
    }

    public static Date asDate(TemporalAccessor dateTime) {
        LocalDateTime dt = LocalDateTime.from(dateTime);
        ZonedDateTime zdt = dt.atZone(ZoneId.systemDefault());
        return Date.from(zdt.toInstant());
    }

    public static boolean isAfterOrEquals(org.joda.time.LocalDate a, org.joda.time.LocalDate b) {
        return !a.isBefore((ReadablePartial)b);
    }

    public static boolean isBeforeOrEquals(org.joda.time.LocalDate a, org.joda.time.LocalDate b) {
        return !a.isAfter((ReadablePartial)b);
    }

    @Nullable
    public static org.joda.time.LocalDate redefinedToday() {
        try {
            String prop = System.getProperty("ic3.today");
            if (CdStringUtils.isNotNullAndNotBlank(prop)) {
                return org.joda.time.LocalDate.parse((String)prop);
            }
            return null;
        }
        catch (Throwable ignored) {
            return null;
        }
    }

    public static LocalDateTime toJavaLocalDateTime(org.joda.time.LocalDateTime jodaLocalDateTime) {
        return LocalDateTime.of(jodaLocalDateTime.getYear(), jodaLocalDateTime.getMonthOfYear(), jodaLocalDateTime.getDayOfMonth(), jodaLocalDateTime.getHourOfDay(), jodaLocalDateTime.getMinuteOfHour(), jodaLocalDateTime.getSecondOfMinute(), jodaLocalDateTime.getMillisOfSecond() * 1000000);
    }

    public static LocalDate toJavaLocalDate(org.joda.time.LocalDate jodaLocalDate) {
        return LocalDate.of(jodaLocalDate.getYear(), jodaLocalDate.getMonthOfYear(), jodaLocalDate.getDayOfMonth());
    }
}

