/*
 * Decompiled with CFR 0.152.
 */
package crazydev.common.utils;

import crazydev.common.exception.CdRuntimeException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Base64;
import java.util.Locale;
import java.util.StringJoiner;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.text.WordUtils;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nullable;

public abstract class CdStringUtils {
    public static final String DOT = ".";
    public static final String COLON = ":";
    private static final DecimalFormatSymbols formatSymbols = new DecimalFormatSymbols(Locale.ENGLISH);

    public static String formatAverage(double value) {
        DecimalFormat df = new DecimalFormat("0.00", formatSymbols);
        return df.format(value);
    }

    public static String formatPercent(double value) {
        DecimalFormat df = new DecimalFormat("0.0#%", formatSymbols);
        return df.format(value);
    }

    public static String formatScientific(double value) {
        DecimalFormat nf = new DecimalFormat("0.##E0", formatSymbols);
        return nf.format(value);
    }

    public static String formatForLogs(double value) {
        if (value == (double)((long)value)) {
            return CdStringUtils.formatNice((long)value);
        }
        return String.format("%.2E", value);
    }

    public static String formatNice(long value) {
        DecimalFormat df = new DecimalFormat("0", formatSymbols);
        df.setGroupingUsed(true);
        df.setGroupingSize(3);
        return df.format(value);
    }

    @Nullable
    public static String extract(String value, String begin, String end) {
        if (begin.contains(end)) {
            throw new CdRuntimeException("end [" + end + "] should not be contained in begin [" + begin + "]");
        }
        int indexBegin = value.indexOf(begin);
        int indexEnd = value.indexOf(end, indexBegin);
        if (indexEnd == -1 || indexBegin == -1) {
            return null;
        }
        if (indexEnd <= indexBegin) {
            return "";
        }
        return value.substring(indexBegin + begin.length(), indexEnd);
    }

    public static String multiply(int times, char ch) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < times; ++i) {
            builder.append(ch);
        }
        return builder.toString();
    }

    @Contract(value="null -> false")
    public static boolean isNotEmpty(@Nullable String string) {
        return !CdStringUtils.isEmpty(string);
    }

    @Contract(value="null -> true")
    public static boolean isEmpty(@Nullable String string) {
        if (CdStringUtils.isStrictlyEmptyOrNull(string)) {
            return true;
        }
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (Character.isWhitespace(c) || c == '\t') continue;
            return false;
        }
        return true;
    }

    @Contract(value="null -> false")
    public static boolean isNotNullAndNotBlank(@Nullable String string) {
        return !CdStringUtils.isNullOrBlank(string);
    }

    @Contract(value="null -> true")
    public static boolean isNullOrBlank(@Nullable String string) {
        return string == null || string.isBlank();
    }

    @Contract(value="null -> true")
    public static boolean isStrictlyEmptyOrNull(@Nullable String string) {
        return string == null || string.isEmpty();
    }

    public static String toCamel(String string, char switcher) {
        boolean keepAsItIs;
        boolean bl = keepAsItIs = CdStringUtils.testForEach(string = string.trim(), Character::isSpaceChar) && CdStringUtils.testForEach(string, Character::isLowerCase) && CdStringUtils.testForEach(string, Character::isUpperCase);
        if (keepAsItIs) {
            return string;
        }
        StringBuilder buffer = new StringBuilder();
        boolean nextUpper = false;
        for (int i = 0; i < string.length(); ++i) {
            char charAt = string.charAt(i);
            buffer.append(nextUpper ? Character.toUpperCase(charAt) : Character.toLowerCase(charAt));
            nextUpper = charAt == switcher;
        }
        return buffer.toString();
    }

    public static boolean isCamel(String string) {
        for (int i = 0; i < string.length(); ++i) {
            char charAt = string.charAt(i);
            if (!Character.isLetter(charAt) || (i != 0 || !Character.isLowerCase(charAt)) && (i == 0 || !Character.isUpperCase(charAt))) continue;
            return false;
        }
        return true;
    }

    public static boolean isAllLetterUpperCase(String string) {
        for (int i = 0; i < string.length(); ++i) {
            char charAt = string.charAt(i);
            if (!Character.isLetter(charAt) || Character.isUpperCase(charAt)) continue;
            return false;
        }
        return true;
    }

    public static boolean isAllLetterLowerCase(String string) {
        for (int i = 0; i < string.length(); ++i) {
            char charAt = string.charAt(i);
            if (!Character.isLetter(charAt) || Character.isLowerCase(charAt)) continue;
            return false;
        }
        return true;
    }

    public static int countLetters(String string) {
        int count = 0;
        for (int i = 0; i < string.length(); ++i) {
            char charAt = string.charAt(i);
            if (!Character.isLetter(charAt)) continue;
            ++count;
        }
        return count;
    }

    public static int countCharMatches(String string, String lookup) {
        int count = 0;
        block0: for (int i = 0; i < string.length(); ++i) {
            char charAt = string.charAt(i);
            for (int ii = 0; ii < lookup.length(); ++ii) {
                if (charAt != lookup.charAt(ii)) continue;
                ++count;
                continue block0;
            }
        }
        return count;
    }

    public static String asSingleLine(String text, boolean prependSpace) {
        try {
            String line;
            StringBuilder sb = new StringBuilder();
            BufferedReader in = new BufferedReader(new StringReader(text));
            while ((line = in.readLine()) != null) {
                if (prependSpace) {
                    sb.append(' ');
                }
                sb.append(line);
            }
            return sb.toString();
        }
        catch (IOException ex) {
            throw new CdRuntimeException((Throwable)ex, "Could not process as single line : " + ex.getMessage());
        }
    }

    public static String formatNice(int value, int formerValue) {
        String res = CdStringUtils.formatNice(value);
        return formerValue < 0 ? res : res + "(+" + CdStringUtils.formatNice(value - formerValue) + ")";
    }

    public static String formatNice(long value, long formerValue) {
        String res = CdStringUtils.formatNice(value);
        return formerValue < 0L ? res : res + "(+" + CdStringUtils.formatNice(value - formerValue) + ")";
    }

    public static String getAfterLast(String dbName, String regExp) {
        Matcher matcher = Pattern.compile(regExp).matcher(dbName);
        int end = 0;
        while (matcher.find()) {
            end = matcher.end();
        }
        return dbName.substring(end);
    }

    public static String removeQuotes(String value) {
        return value.replaceAll("^\"|\"$", "");
    }

    public static double similarity(String left, String right) {
        int leftLength;
        if (left.length() < right.length()) {
            String swap = left;
            left = right;
            right = swap;
        }
        if ((leftLength = left.length()) == 0) {
            return 1.0;
        }
        return (double)(leftLength - CdStringUtils.computeEditDistance(left, right)) / (double)leftLength;
    }

    private static int computeEditDistance(String s1, String s2) {
        s1 = s1.toLowerCase();
        s2 = s2.toLowerCase();
        int[] costs = new int[s2.length() + 1];
        for (int ii = 0; ii <= s1.length(); ++ii) {
            int lastValue = ii;
            for (int jj = 0; jj <= s2.length(); ++jj) {
                if (ii == 0) {
                    costs[jj] = jj;
                    continue;
                }
                if (jj <= 0) continue;
                int newValue = costs[jj - 1];
                if (s1.charAt(ii - 1) != s2.charAt(jj - 1)) {
                    newValue = Math.min(Math.min(newValue, lastValue), costs[jj]) + 1;
                }
                costs[jj - 1] = lastValue;
                lastValue = newValue;
            }
            if (ii <= 0) continue;
            costs[s2.length()] = lastValue;
        }
        return costs[s2.length()];
    }

    @Nullable
    public static String asNull(@Nullable String str) {
        return CdStringUtils.isNullOrBlank(str) ? null : str;
    }

    public static String replaceAllNotInSimpleQuote(String string, Pattern search, String replacement) {
        return search.matcher(string).replaceAll(replacement);
    }

    public static String camelCase(String value) {
        boolean isUpperLowerMixed;
        boolean keepAsItIs;
        boolean bl = keepAsItIs = CdStringUtils.testForEach(value = value.trim(), Character::isSpaceChar) && CdStringUtils.testForEach(value, Character::isLowerCase) && CdStringUtils.testForEach(value, Character::isUpperCase);
        if (keepAsItIs) {
            return value;
        }
        if (CdStringUtils.isNullOrBlank(value)) {
            return value;
        }
        char[] delimiters = new char[]{'_', ' '};
        boolean hasDelimiters = CdStringUtils.hasDelimiters(delimiters, value);
        if (!hasDelimiters && (isUpperLowerMixed = CdStringUtils.isUpperLowerMixed(value))) {
            value = CdStringUtils.addSeparator(value);
            return value;
        }
        value = WordUtils.capitalizeFully((String)value, (char[])delimiters);
        value = value.replace("_", " ");
        return value;
    }

    private static String addSeparator(String value) {
        StringBuilder sb = new StringBuilder();
        for (int ii = 0; ii < value.length(); ++ii) {
            char cc = value.charAt(ii);
            if (ii == 0) {
                sb.append(Character.toUpperCase(cc));
                continue;
            }
            if (Character.isUpperCase(cc)) {
                sb.append(' ');
                sb.append(cc);
                if (!CdStringUtils.isUpperCase(value, ii + 1)) continue;
                for (int zz = ii + 1; zz < value.length(); ++zz) {
                    sb.append(value.charAt(zz));
                }
                break;
            }
            sb.append(cc);
        }
        return sb.toString();
    }

    private static boolean isUpperCase(String value, int from) {
        for (int ii = from; ii < value.length(); ++ii) {
            char cc = value.charAt(ii);
            if (!Character.isLowerCase(cc)) continue;
            return false;
        }
        return true;
    }

    private static boolean isUpperLowerMixed(String value) {
        boolean hasUpper = false;
        boolean hasLower = false;
        for (int ii = 0; ii < value.length(); ++ii) {
            char cc = value.charAt(ii);
            if (Character.isUpperCase(cc)) {
                hasUpper = true;
            } else {
                hasLower = true;
            }
            if (!hasUpper || !hasLower) continue;
            return true;
        }
        return false;
    }

    private static boolean hasDelimiters(char[] delimiters, String value) {
        for (int ii = 0; ii < value.length(); ++ii) {
            char cc = value.charAt(ii);
            if (!CdStringUtils.isDelimiter(delimiters, cc)) continue;
            return true;
        }
        return false;
    }

    private static boolean isDelimiter(char[] delimiters, char c) {
        for (int ii = 0; ii < delimiters.length; ++ii) {
            if (c != delimiters[ii]) continue;
            return true;
        }
        return false;
    }

    public static String getSHA512Hash(String str) {
        return Base64.getEncoder().encodeToString(DigestUtils.sha512((String)str));
    }

    public static void join(StringBuilder sb, Iterable<?> iter, String separator, String cutText, int limit) {
        int count = 0;
        for (Object o : iter) {
            if (count++ != 0) {
                sb.append(separator);
            }
            if (limit != -1 && count >= limit) {
                sb.append(cutText);
                break;
            }
            sb.append(o);
        }
    }

    public static String spaces(int count) {
        return String.format("%1$" + count + "s", "");
    }

    public static String coalesceEmpty(String ... names) {
        if (names == null) {
            return null;
        }
        for (int i = 0; i < names.length; ++i) {
            String name = names[i];
            if (!CdStringUtils.isNotNullAndNotBlank(name)) continue;
            return name;
        }
        return null;
    }

    public static <T> String join(String delimiter, Iterable<T> list, Function<T, String> converter) {
        StringJoiner joiner = new StringJoiner(delimiter);
        for (T t : list) {
            joiner.add(converter.apply(t));
        }
        return joiner.toString();
    }

    public static boolean testForEach(String str, Predicate<Character> vistor) {
        char[] chars = str.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            if (!vistor.test(Character.valueOf(chars[i]))) continue;
            return true;
        }
        return false;
    }

    static {
        formatSymbols.setGroupingSeparator('\'');
    }
}

