/*
 * Decompiled with CFR 0.152.
 */
package crazydev.common.utils;

import crazydev.common.exception.CdResourceNotFoundRuntimeException;
import crazydev.common.exception.CdRuntimeException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.StandardCharsets;

public abstract class CdResourceUtils {
    public static String getResourceAsString(Class clazz, String resource) {
        InputStream in = CdResourceUtils.getResourceAsStream(clazz, resource);
        try {
            int c;
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            while ((c = in.read()) != -1) {
                out.write(c);
            }
            out.flush();
            return new String(out.toByteArray(), StandardCharsets.UTF_8);
        }
        catch (IOException ex) {
            throw new CdRuntimeException((Throwable)ex, "Could not read the resource [" + resource + "]");
        }
    }

    public static InputStream getResourceAsStream(Class clazz, String resource) {
        String name = CdResourceUtils.findFileName(clazz, resource);
        InputStream stream = null;
        ClassLoader classLoader = clazz.getClassLoader();
        if (classLoader != null) {
            stream = classLoader.getResourceAsStream(name);
        }
        if (stream == null) {
            stream = ClassLoader.getSystemResourceAsStream(name);
        }
        if (stream == null) {
            throw new CdRuntimeException("Resource [" + resource + "][" + name + "] not found");
        }
        return stream;
    }

    private static String findFileName(Class clazz, String resource) {
        return !resource.startsWith("/") ? clazz.getPackage().getName().replace(".", "/") + "/" + resource : resource;
    }

    public static URL getResourceAsURL(Class clazz, String resource) throws CdResourceNotFoundRuntimeException {
        String name = CdResourceUtils.findFileName(clazz, resource);
        URL url = null;
        ClassLoader classLoader = clazz.getClassLoader();
        if (classLoader != null) {
            url = classLoader.getResource(name);
        }
        if (url == null) {
            url = ClassLoader.getSystemResource(name);
        }
        if (url == null) {
            throw new CdResourceNotFoundRuntimeException(resource, name);
        }
        return url;
    }
}

