/*
 * Decompiled with CFR 0.152.
 */
package crazydev.common.utils;

import crazydev.common.collection.CdIIntArrayList;
import crazydev.common.collection.CdIntArrayList;
import crazydev.common.system.CdRamUsageEstimator;
import crazydev.common.utils.CdPackedBitList;

public class CdResizablePackedBitList
implements CdIIntArrayList {
    private static long SHALLOW_SIZE_OF = -1L;
    CdIntArrayList list;
    private CdIIntArrayList packed;

    public CdResizablePackedBitList() {
        this.packed = new CdIntArrayList();
    }

    public CdResizablePackedBitList(int size) {
        this.packed = new CdIntArrayList(size);
    }

    @Override
    public int getInt(int idx) {
        if (this.list != null) {
            return this.list.getInt(idx);
        }
        return this.packed.getInt(idx);
    }

    @Override
    public int set(int idx, int value) {
        if (this.list == null) {
            if (this.packed instanceof CdIntArrayList) {
                this.list = (CdIntArrayList)this.packed;
            } else {
                this.list = new CdIntArrayList(Math.max(16, this.packed.size()));
                for (int i = 0; i < this.packed.size(); ++i) {
                    int val = this.packed.getInt(i);
                    if (val == 0) continue;
                    this.list.set(i, val);
                }
            }
        }
        return this.list.set(idx, value);
    }

    @Override
    public int size() {
        return this.packed.size() + (this.list == null ? 0 : this.list.size());
    }

    @Override
    public long sizeOf() {
        long sizeOf = SHALLOW_SIZE_OF != -1L ? SHALLOW_SIZE_OF : (SHALLOW_SIZE_OF = CdRamUsageEstimator.shallowSizeOf(this));
        sizeOf += this.packed.sizeOf();
        return sizeOf += this.list == null ? 0L : this.list.sizeOf();
    }

    @Override
    public void trimToSize() {
        if (this.list == null) {
            return;
        }
        this.packed = CdPackedBitList.buildIfCompressing(this.list);
        if (this.packed == null) {
            this.packed = this.list;
        }
        this.list = null;
    }
}

