/*
 * Decompiled with CFR 0.152.
 */
package crazydev.common.utils;

import java.util.ArrayList;
import java.util.List;

public class CdPeriodFormatter {
    private final String format;
    private final List<Periods> formatPeriods = new ArrayList<Periods>(Periods.values().length);

    public CdPeriodFormatter(String format) {
        this.format = format;
        for (Periods period : Periods.values()) {
            if (!format.contains("%" + period.token)) continue;
            this.formatPeriods.add(period);
        }
    }

    public static String format(long milliseconds, String format) {
        return new CdPeriodFormatter(format).format(milliseconds);
    }

    public String format(long milliseconds) {
        String res = this.format;
        long millis = milliseconds;
        for (Periods period : this.formatPeriods) {
            long numberPeriods = millis / period.duration;
            millis %= period.duration;
            res = res.replace("%" + period.token, Long.toString(numberPeriods));
        }
        return res;
    }

    private static enum Periods {
        year("y", 31536000000L),
        month("M", 2592000000L),
        day("d", 86400000L),
        hour("h", 3600000L),
        minute("m", 60000L),
        second("s", 1000L),
        mili("S", 1L);

        private final String token;
        private final long duration;

        private Periods(String token, long millis) {
            this.token = token;
            this.duration = millis;
        }
    }
}

