/*
 * Decompiled with CFR 0.152.
 */
package crazydev.common.utils;

import org.jetbrains.annotations.Nullable;

public abstract class CdPathUtils {
    private CdPathUtils() {
    }

    public static String path(String parent, String child) {
        if (!((String)parent).endsWith("/")) {
            parent = (String)parent + "/";
        }
        if (child.startsWith("/")) {
            child = child.substring(1);
        }
        String path = (String)parent + child;
        return path;
    }

    @Nullable
    public static String normalize(String filename) {
        int i;
        int size = filename.length();
        if (size == 0) {
            return filename;
        }
        int prefix = 0;
        char[] array = new char[size + 2];
        filename.getChars(0, filename.length(), array, 0);
        char separator = '/';
        boolean lastIsDirectory = true;
        if (array[size - 1] != separator) {
            array[size++] = separator;
            lastIsDirectory = false;
        }
        for (i = prefix + 1; i < size; ++i) {
            if (array[i] != separator || array[i - 1] != separator) continue;
            System.arraycopy(array, i, array, i - 1, size - i);
            --size;
            --i;
        }
        for (i = prefix + 1; i < size; ++i) {
            if (array[i] != separator || array[i - 1] != '.' || i != prefix + 1 && array[i - 2] != separator) continue;
            if (i == size - 1) {
                lastIsDirectory = true;
            }
            System.arraycopy(array, i + 1, array, i - 1, size - i);
            size -= 2;
            --i;
        }
        block2: for (i = prefix + 2; i < size; ++i) {
            if (array[i] != separator || array[i - 1] != '.' || array[i - 2] != '.' || i != prefix + 2 && array[i - 3] != separator) continue;
            if (i == prefix + 2) {
                return null;
            }
            if (i == size - 1) {
                lastIsDirectory = true;
            }
            for (int j = i - 4; j >= prefix; --j) {
                if (array[j] != separator) continue;
                System.arraycopy(array, i + 1, array, j + 1, size - i);
                size -= i - j;
                i = j + 1;
                continue block2;
            }
            System.arraycopy(array, i + 1, array, prefix, size - i);
            size -= i + 1 - prefix;
            i = prefix + 1;
        }
        if (size <= 0) {
            return "";
        }
        if (size <= prefix) {
            return new String(array, 0, size);
        }
        boolean keepSeparator = false;
        if (lastIsDirectory) {
            // empty if block
        }
        return new String(array, 0, size - 1);
    }
}

