/*
 * Decompiled with CFR 0.152.
 */
package crazydev.common.utils;

public abstract class CdPathEscapeUtils {
    public static final char PERCENT = '%';
    public static final String FILE_ILLEGAL_CHARS = "%<>:\"/\\|?*";
    public static final String UUID_ILLEGAL_CHARS = "%/|";
    public static final String SIMPLE_PATH_ILLEGAL_CHARS = "%/";

    private CdPathEscapeUtils() {
    }

    public static String escapeUuidName(String value) {
        return CdPathEscapeUtils.escapeIllegalChars(value, UUID_ILLEGAL_CHARS);
    }

    public static String unescapeUuidName(String value) {
        return CdPathEscapeUtils.unescapeIllegalChars(value);
    }

    public static String escapeSimplePathName(String value) {
        return CdPathEscapeUtils.escapeIllegalChars(value, SIMPLE_PATH_ILLEGAL_CHARS);
    }

    public static String unescapeSimplePathName(String value) {
        return CdPathEscapeUtils.unescapeIllegalChars(value);
    }

    public static String escapeFileName(String value) {
        return CdPathEscapeUtils.escapeIllegalChars(value, FILE_ILLEGAL_CHARS);
    }

    public static String unescapeFileName(String value) {
        return CdPathEscapeUtils.unescapeIllegalChars(value);
    }

    private static String escapeIllegalChars(String value, String illegal) {
        StringBuilder sb = new StringBuilder();
        if (value.equals(".")) {
            CdPathEscapeUtils.escapeIllegalChar(sb, '.');
        } else if (value.equals("..")) {
            CdPathEscapeUtils.escapeIllegalChar(sb, '.');
            CdPathEscapeUtils.escapeIllegalChar(sb, '.');
        } else {
            int len = value.length();
            for (int cc = 0; cc < len; ++cc) {
                char ch = value.charAt(cc);
                if (illegal.indexOf(ch) == -1) {
                    sb.append(ch);
                    continue;
                }
                CdPathEscapeUtils.escapeIllegalChar(sb, ch);
            }
        }
        String escaped = sb.toString();
        return escaped;
    }

    private static void escapeIllegalChar(StringBuilder buffer, char ch) {
        buffer.append('%');
        buffer.append(Character.toUpperCase(Character.forDigit(ch / 16, 16)));
        buffer.append(Character.toUpperCase(Character.forDigit(ch % 16, 16)));
    }

    private static String unescapeIllegalChars(String value) {
        StringBuilder sb = new StringBuilder();
        int cc = value.indexOf(37);
        while (cc > -1 && cc + 2 < value.length()) {
            sb.append(value.toCharArray(), 0, cc);
            int a = Character.digit(value.charAt(cc + 1), 16);
            int b = Character.digit(value.charAt(cc + 2), 16);
            if (a > -1 && b > -1) {
                sb.append((char)(a * 16 + b));
                value = value.substring(cc + 3);
            } else {
                sb.append('%');
                value = value.substring(cc + 1);
            }
            cc = value.indexOf(37);
        }
        sb.append(value);
        String unescaped = sb.toString();
        return unescaped;
    }
}

