/*
 * Decompiled with CFR 0.152.
 */
package crazydev.common.utils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

public abstract class CdModifiedUTF8StringUtils {
    public static final byte EOS = 0;
    public static final char STRING_NULL = '\udc80';
    public static final byte STRING_NULL_B1 = -36;
    public static final byte STRING_NULL_B2 = -128;
    public static final char EMBEDDED_NULL = '\uc080';
    public static final byte EMBEDDED_NULL_B1 = -64;
    public static final byte EMBEDDED_NULL_B2 = -128;

    public static byte[] toModifiedUTF8(@Nullable String str) {
        return CdModifiedUTF8StringUtils._toModifiedUTF8(str, null);
    }

    public static byte[] toModifiedUTF8(@Nullable String str, byte eos) {
        return CdModifiedUTF8StringUtils._toModifiedUTF8(str, eos);
    }

    private static byte[] _toModifiedUTF8(@Nullable String str, @Nullable Byte eos) {
        char c;
        if (str == null) {
            byte[] bytearr = new byte[2 + (eos != null ? 1 : 0)];
            bytearr[0] = -36;
            bytearr[1] = -128;
            if (eos != null) {
                bytearr[bytearr.length - 1] = eos;
            }
            return bytearr;
        }
        if ("\u0700".equals(str)) {
            throw new RuntimeException("unsupported string [" + str + "] value");
        }
        int strlen = str.length();
        int utflen = 0;
        int count = 0;
        for (int idx = 0; idx < strlen; ++idx) {
            c = str.charAt(idx);
            if (c >= '\u0001' && c <= '\u007f') {
                ++utflen;
                continue;
            }
            if (c > '\u07ff') {
                utflen += 3;
                continue;
            }
            utflen += 2;
        }
        byte[] bytearr = new byte[utflen + (eos != null ? 1 : 0)];
        int i = 0;
        for (i = 0; i < strlen && (c = str.charAt(i)) >= '\u0001' && c <= '\u007f'; ++i) {
            bytearr[count++] = (byte)c;
        }
        while (i < strlen) {
            c = str.charAt(i);
            if (c >= '\u0001' && c <= '\u007f') {
                bytearr[count++] = (byte)c;
            } else if (c > '\u07ff') {
                bytearr[count++] = (byte)(0xE0 | c >> 12 & 0xF);
                bytearr[count++] = (byte)(0x80 | c >> 6 & 0x3F);
                bytearr[count++] = (byte)(0x80 | c & 0x3F);
            } else {
                bytearr[count++] = (byte)(0xFFFFFFC0 | c >> 6 & 0x1F);
                bytearr[count++] = (byte)(0xFFFFFF80 | c & 0x3F);
            }
            ++i;
        }
        if (eos != null) {
            bytearr[bytearr.length - 1] = eos;
        }
        return bytearr;
    }

    @Nullable
    public static String toString(byte[] bytearr) {
        int c1;
        int count;
        char[] chararr = new char[bytearr.length];
        int chararr_count = 0;
        if (bytearr.length == 2 && bytearr[0] == -36 && bytearr[1] == -128) {
            return null;
        }
        for (count = 0; count < bytearr.length && (c1 = bytearr[count] & 0xFF) <= 127; ++count) {
            chararr[chararr_count++] = (char)c1;
        }
        block6: while (count < bytearr.length) {
            c1 = bytearr[count] & 0xFF;
            switch (c1 >> 4) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    ++count;
                    chararr[chararr_count++] = (char)c1;
                    continue block6;
                }
                case 12: 
                case 13: {
                    if ((count += 2) > bytearr.length) {
                        throw new RuntimeException("malformed input: partial character at end");
                    }
                    byte c2 = bytearr[count - 1];
                    if ((c2 & 0xC0) != 128) {
                        throw new RuntimeException("malformed input around byte " + count);
                    }
                    chararr[chararr_count++] = (char)((c1 & 0x1F) << 6 | c2 & 0x3F);
                    continue block6;
                }
                case 14: {
                    if ((count += 3) > bytearr.length) {
                        throw new RuntimeException("malformed input: partial character at end");
                    }
                    byte c2 = bytearr[count - 2];
                    byte c3 = bytearr[count - 1];
                    if ((c2 & 0xC0) != 128 || (c3 & 0xC0) != 128) {
                        throw new RuntimeException("malformed input around byte " + (count - 1));
                    }
                    chararr[chararr_count++] = (char)((c1 & 0xF) << 12 | (c2 & 0x3F) << 6 | c3 & 0x3F);
                    continue block6;
                }
            }
            throw new RuntimeException("malformed input around byte " + count);
        }
        return new String(chararr, 0, chararr_count);
    }

    public static void main(String[] args) {
        int count = 0;
        HashMap toUpper = new HashMap();
        HashMap toLower = new HashMap();
        for (int charValue = 0; charValue <= Short.MAX_VALUE; ++charValue) {
            char l_c;
            List<Character> chars;
            char c = (char)charValue;
            if (!Character.isDefined(c)) continue;
            char u_c = Character.toUpperCase(c);
            if (c != u_c) {
                chars = (ArrayList<Character>)toUpper.get(Character.valueOf(u_c));
                if (chars == null) {
                    chars = new ArrayList<Character>();
                    toUpper.put(Character.valueOf(u_c), chars);
                }
                chars.add(Character.valueOf(c));
            }
            if (c != (l_c = Character.toLowerCase(c))) {
                chars = (List)toLower.get(Character.valueOf(l_c));
                if (chars == null) {
                    chars = new ArrayList();
                    toLower.put(Character.valueOf(l_c), chars);
                }
                chars.add(Character.valueOf(c));
            }
            ++count;
        }
        System.out.println("char-count: " + count);
        System.out.println("");
        System.out.println("to-upper-mapping");
        for (Map.Entry entry : toUpper.entrySet()) {
            if (((List)entry.getValue()).size() <= 1) continue;
            System.out.print(String.valueOf(entry.getKey()) + " : ");
            for (Character character : (List)entry.getValue()) {
                System.out.print(" " + character);
            }
            System.out.println("");
        }
        System.out.println("");
        System.out.println("to-lower-mapping");
        for (Map.Entry entry : toLower.entrySet()) {
            if (((List)entry.getValue()).size() <= 1) continue;
            System.out.print(String.valueOf(entry.getKey()) + " : ");
            for (Character character : (List)entry.getValue()) {
                System.out.print(" " + character);
            }
            System.out.println("");
        }
        count = 0;
        System.out.println("");
        System.out.println("code-points");
        for (long codePoint = 0L; codePoint <= Integer.MAX_VALUE; ++codePoint) {
            if (!Character.isDefined((int)codePoint)) continue;
            char l_c = (char)Character.toLowerCase((int)codePoint);
            char u_c = (char)Character.toUpperCase((int)codePoint);
            byte[] l_utf8 = CdModifiedUTF8StringUtils.toModifiedUTF8(new String(new char[]{l_c}));
            byte[] u_utf8 = CdModifiedUTF8StringUtils.toModifiedUTF8(new String(new char[]{u_c}));
            if (l_utf8.length != u_utf8.length) {
                System.out.println("* code-point:" + codePoint + " " + l_utf8.length + "/" + u_utf8.length + " " + l_c + "/" + u_c);
            }
            ++count;
        }
        System.out.println(count);
    }
}

