/*
 * Decompiled with CFR 0.152.
 */
package crazydev.common.utils;

import java.lang.reflect.Field;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.sql.Types;
import java.util.HashMap;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public abstract class CdJdbcUtils {
    public static final Logger LOGGER = Logger.getLogger((String)"icCube.sql.jdbc");
    private static final HashMap<Integer, String> jdbcTypeMap1 = new HashMap();
    private static final HashMap<String, Integer> jdbcTypeMap2 = new HashMap();

    public static void cancelQuietly(@Nullable Statement statement) {
        try {
            if (statement != null && !statement.isClosed()) {
                statement.cancel();
            }
        }
        catch (Exception ignored) {
            LOGGER.warn((Object)"Failed to cancel successfully a JDBC statement!", (Throwable)ignored);
        }
    }

    public static void closeQuietly(@Nullable ResultSet rs) {
        try {
            if (rs != null) {
                rs.close();
            }
        }
        catch (Exception ignored) {
            LOGGER.warn((Object)"Failed to close successfully a JDBC result set!", (Throwable)ignored);
        }
    }

    public static void closeQuietly(@Nullable Statement stmt) {
        try {
            if (stmt != null) {
                stmt.close();
            }
        }
        catch (Exception ignored) {
            LOGGER.warn((Object)"Failed to close successfully a JDBC statement!", (Throwable)ignored);
        }
    }

    public static void closeQuietly(@Nullable Connection connection) {
        CdJdbcUtils.closeQuietly(connection, true);
    }

    public static void closeQuietly(@Nullable Connection connection, boolean rollback) {
        try {
            if (connection != null && rollback) {
                connection.rollback();
            }
        }
        catch (Exception ignored) {
            LOGGER.warn((Object)"Failed to rollback successfully a JDBC connection!", (Throwable)ignored);
        }
        try {
            if (connection != null) {
                connection.close();
            }
        }
        catch (Exception ignored) {
            LOGGER.warn((Object)"Failed to close successfully a JDBC connection!", (Throwable)ignored);
        }
    }

    @Nullable
    public static String getJdbcTypeName(int jdbcType) {
        return jdbcTypeMap1.get(jdbcType);
    }

    @Nullable
    public static Integer getJdbcType(String jdbcName) {
        return jdbcTypeMap2.get(jdbcName);
    }

    private static void init() throws IllegalAccessException {
        Field[] fields = Types.class.getFields();
        for (int i = 0; i < fields.length; ++i) {
            String name = fields[i].getName();
            Integer value = (Integer)fields[i].get(null);
            jdbcTypeMap1.put(value, name);
            jdbcTypeMap2.put(name, value);
        }
    }

    static {
        try {
            CdJdbcUtils.init();
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }
}

