/*
 * Decompiled with CFR 0.152.
 */
package crazydev.common.utils;

import crazydev.common.exception.CdCommonError;
import crazydev.common.exception.CdCommonErrorCode;
import crazydev.common.exception.CdRuntimeException;
import crazydev.common.utils.CdStringUtils;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.net.URL;
import java.security.CodeSource;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import org.jetbrains.annotations.Nullable;

public abstract class CdClassUtils {
    public static <T> boolean equals(@Nullable T left, @Nullable T right) {
        if (left == null || right == null || left == right) {
            return left == right;
        }
        return left.equals(right);
    }

    public static String getSimpleName(String className) {
        if (className == null) {
            return "null";
        }
        return className.substring(className.lastIndexOf(".") + 1);
    }

    public static <T> List<Class<T>> getSupersR(Class<? extends T> from, Class<T> upTo) {
        if (!upTo.isAssignableFrom(from)) {
            return Collections.emptyList();
        }
        ArrayList<Class<T>> classes = new ArrayList<Class<T>>();
        CdClassUtils.doGetSupersR(classes, from, upTo);
        return classes;
    }

    private static <T> void doGetSupersR(List<Class<T>> classes, Class from, Class<T> upTo) {
        if (upTo.isAssignableFrom(from) && !classes.contains(from)) {
            Class<?>[] xintfs;
            classes.add(from);
            Class xclass = from.getSuperclass();
            if (xclass != null) {
                CdClassUtils.doGetSupersR(classes, xclass, upTo);
            }
            for (Class<?> xintf : xintfs = from.getInterfaces()) {
                CdClassUtils.doGetSupersR(classes, xintf, upTo);
            }
        }
    }

    public static <A extends Annotation> A getExistingAnnotation(Class clazz, Class<A> annotation) {
        A an = clazz.getAnnotation(annotation);
        if (an == null) {
            throw new CdRuntimeException("Unable to find annotation [" + String.valueOf(annotation) + "] in class [" + String.valueOf(clazz) + "]");
        }
        return an;
    }

    public static void assertMethodParameterTypes(Method method, Class ... paramTypes) {
        Class<?>[] methodParamTypes = method.getParameterTypes();
        if (methodParamTypes.length == 0 && (paramTypes == null || paramTypes.length != 0)) {
            throw new CdRuntimeException("Expected no parameters in method[" + String.valueOf(method) + "]");
        }
        if (methodParamTypes.length != paramTypes.length) {
            throw new CdRuntimeException("Expected [" + methodParamTypes.length + "] parameters in method[" + String.valueOf(method) + "], got [" + paramTypes.length + "]");
        }
        for (int i = 0; i < methodParamTypes.length; ++i) {
            Class<?> methodParamType = methodParamTypes[i];
            Class paramType = paramTypes[i];
            if (methodParamType == paramType) continue;
            throw new CdRuntimeException("Different parameters types method[" + String.valueOf(method) + "], got [" + paramTypes.length + "] at pos [" + i + "]");
        }
    }

    public static void assertMethodReturnType(Method method, Class returnType, Class ... genericType) {
        Class<?> methodReturnType = method.getReturnType();
        if (methodReturnType != returnType) {
            throw new CdRuntimeException("Expected [" + String.valueOf(returnType) + "] return class is different from the one defined [" + String.valueOf(methodReturnType) + "] in the method [" + String.valueOf(method) + "]");
        }
        Type generic = method.getGenericReturnType();
        if (genericType != null && genericType.length != 0 && generic instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)generic;
            Type[] types = parameterizedType.getActualTypeArguments();
            if (types.length != genericType.length) {
                throw new CdRuntimeException("Expected same generic type numbers,in the method [" + String.valueOf(method) + "]: expected [" + types.length + "], got [" + genericType.length + "]");
            }
            for (int i = 0; i < types.length; ++i) {
                Class gtype = genericType[i];
                Type type = types[i];
                if (gtype == type) continue;
                throw new CdRuntimeException("Expected [" + Arrays.toString(genericType) + "] return generic type is different from the one defined [" + String.valueOf(parameterizedType) + "] in the method [" + String.valueOf(method) + "]");
            }
        }
    }

    public static List<Field> getAllDeclaredFields(Class aClass) {
        ArrayList<Field> fields = new ArrayList<Field>();
        Class clazz = aClass;
        do {
            fields.addAll(Arrays.asList(clazz.getDeclaredFields()));
        } while ((clazz = clazz.getSuperclass()) != Object.class);
        return fields;
    }

    public static List<Field> getAllDeclaredStaticFields(Class ofType, Class fromClass) {
        Field[] fields = fromClass.getDeclaredFields();
        ArrayList<Field> staticFields = new ArrayList<Field>();
        for (Field field : fields) {
            if (!Modifier.isStatic(field.getModifiers()) || !ofType.isAssignableFrom(field.getType())) continue;
            staticFields.add(field);
        }
        return staticFields;
    }

    public static <A extends Annotation> A getAnnotation(Class clazz, Class<A> annotation) {
        A an = clazz.getAnnotation(annotation);
        if (an != null) {
            return an;
        }
        throw new CdRuntimeException("Missing annotation [" + String.valueOf(annotation) + "] in class [" + String.valueOf(clazz) + "]");
    }

    public static <A extends Annotation> A getAnnotationOnInterface(Class clazz, Class<A> annotation) {
        for (Class<?> aInterface : clazz.getInterfaces()) {
            A an = aInterface.getAnnotation(annotation);
            if (an == null) continue;
            return an;
        }
        throw new CdRuntimeException("Missing annotation [" + String.valueOf(annotation) + "] in class [" + String.valueOf(clazz) + "]");
    }

    public static <T> T instantiateClass(Class<T> clazz) {
        if (clazz.isInterface() || clazz.isAnnotation() || clazz.isEnum() || clazz.isPrimitive()) {
            throw new CdRuntimeException(new CdCommonError(CdCommonErrorCode.TYPE_CANNOT_BE_INSTANTIATED, new Serializable[]{clazz}));
        }
        try {
            Constructor<T> constructor = clazz.getDeclaredConstructor(new Class[0]);
            constructor.setAccessible(true);
            return constructor.newInstance(new Object[0]);
        }
        catch (NoSuchMethodException e) {
            throw new CdRuntimeException((Throwable)e, new CdCommonError(CdCommonErrorCode.CLASS_WITHOUT_DEFAULT_CONSTRUCTOR, new Serializable[]{clazz}));
        }
        catch (InvocationTargetException e) {
            throw new CdRuntimeException((Throwable)e, new CdCommonError(CdCommonErrorCode.UNABLE_TO_INVOKE_CLASS_CONSTRUCTOR, new Serializable[]{clazz, e.getLocalizedMessage()}));
        }
        catch (InstantiationException e) {
            throw new CdRuntimeException((Throwable)e, new CdCommonError(CdCommonErrorCode.IMPOSSIBLE_TO_INSTANTIATE_ABSTRACT_CLASS, new Serializable[]{clazz}));
        }
        catch (IllegalAccessException e) {
            throw new CdRuntimeException((Throwable)e, new CdCommonError(CdCommonErrorCode.ACCESS_TO_THE_CONSTRUCTOR_DENIED, new Serializable[]{clazz}));
        }
    }

    public static void setFieldValue(Field field, Object object, Object value) {
        try {
            field.setAccessible(true);
            field.set(object, value);
        }
        catch (IllegalAccessException e) {
            throw new CdRuntimeException((Throwable)e, new CdCommonError(CdCommonErrorCode.FIELD_VALUE_CANNOT_BE_SET, new Serializable[]{field.getName(), value.toString()}));
        }
    }

    public static Object getFieldValue(Field field, Object object) {
        try {
            field.setAccessible(true);
            return field.get(object);
        }
        catch (IllegalAccessException e) {
            throw new CdRuntimeException((Throwable)e, new CdCommonError(CdCommonErrorCode.FIELD_VALUE_CANNOT_BE_GET, new Serializable[]{field.getName()}));
        }
    }

    public static Field getDeclaredField(Class<?> clazz, String name) throws NoSuchFieldException {
        for (Class<?> internalClazz = clazz; internalClazz != Object.class; internalClazz = internalClazz.getSuperclass()) {
            try {
                return internalClazz.getDeclaredField(name);
            }
            catch (NoSuchFieldException noSuchFieldException) {
                continue;
            }
        }
        throw new NoSuchFieldException("Missing field [" + name + "] from class [" + clazz.getName() + "]");
    }

    @Nullable
    public static URL getClassLocation(Class clazz) {
        CodeSource codeSource = clazz.getProtectionDomain().getCodeSource();
        return codeSource == null ? null : codeSource.getLocation();
    }

    @Nullable
    public static Method getMethod(String className, String methodName) {
        try {
            Class<?> clazz = Class.forName(className);
            return clazz.getMethod(methodName, new Class[0]);
        }
        catch (ClassNotFoundException | NoSuchMethodException e) {
            return null;
        }
    }

    @Nullable
    public static String getParentPackageName(String packageName) {
        if (CdStringUtils.isNullOrBlank(packageName)) {
            return null;
        }
        int dotPos = packageName.lastIndexOf(".");
        if (dotPos == -1) {
            return null;
        }
        String parent = packageName.substring(0, dotPos);
        return CdStringUtils.isNullOrBlank(parent) ? null : parent;
    }

    public static int compareTo(@Nullable Comparable v1, @Nullable Comparable v2) {
        return v1 == null ? (v2 == null ? 0 : -1) : (v2 == null ? 1 : v1.compareTo(v2));
    }

    public static <R, T> R coales(T t, Function<T, R> funIfNotNull, R valueIfNull) {
        if (t == null) {
            return funIfNotNull.apply(t);
        }
        return funIfNotNull.apply(t);
    }
}

