/*
 * Decompiled with CFR 0.152.
 */
package crazydev.common.utils;

import crazydev.common.utils.CdLineReader;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import org.apache.commons.io.IOUtils;

public class CdBufferedMultiLineReader
implements CdLineReader {
    private final List<String> fileNames;
    private final Function<String, BufferedReader> provider;
    private BufferedReader currentBufferedReader;
    private int filePos;

    public CdBufferedMultiLineReader(List<String> fileNames, Function<String, BufferedReader> provider) {
        this.fileNames = fileNames;
        this.provider = provider;
        this.filePos = 0;
        this.currentBufferedReader = provider.apply(fileNames.get(this.filePos));
    }

    @Override
    public String readLine() throws IOException {
        String line = this.currentBufferedReader.readLine();
        if (line == null) {
            this.currentBufferedReader.close();
            if (++this.filePos < this.fileNames.size()) {
                this.currentBufferedReader = this.provider.apply(this.fileNames.get(this.filePos));
                if (this.readLine() == null) {
                    return null;
                }
                return this.readLine();
            }
        }
        return line;
    }

    @Override
    public void close() throws IOException {
        this.currentBufferedReader.close();
    }

    @Override
    public void closeQuietly() {
        IOUtils.closeQuietly((Reader)this.currentBufferedReader);
    }

    @Override
    public String getCurrentFileName() {
        return this.fileNames.get(this.filePos);
    }

    @Override
    public void forEachFileName(Consumer<String> action) {
        this.fileNames.forEach(action);
    }
}

