/*
 * Decompiled with CFR 0.152.
 */
package crazydev.common.utils;

import it.unimi.dsi.fastutil.doubles.DoubleArrayList;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntArrays;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.nio.ByteOrder;
import java.util.Arrays;
import java.util.List;

public abstract class CdArrayUtils {
    public static final byte[] EMPTY_BYTE_ELEMENTDATA = new byte[0];
    private static final int SOFT_MAX_ARRAY_LENGTH = 0x7FFFFFF7;
    private static final VarHandle INT_LE_HANDLE = MethodHandles.byteArrayViewVarHandle(int[].class, ByteOrder.LITTLE_ENDIAN);
    private static final VarHandle CHAR_LE_HANDLE = MethodHandles.byteArrayViewVarHandle(char[].class, ByteOrder.LITTLE_ENDIAN);

    protected CdArrayUtils() {
    }

    protected static int newLength(int oldCapacity, int minCapacity) {
        return CdArrayUtils.newLength(oldCapacity, minCapacity - oldCapacity, oldCapacity >> 1);
    }

    private static int newLength(int oldLength, int minGrowth, int prefGrowth) {
        int prefLength = oldLength + Math.max(minGrowth, prefGrowth);
        if (0 < prefLength && prefLength <= 0x7FFFFFF7) {
            return prefLength;
        }
        return CdArrayUtils.hugeLength(oldLength, minGrowth);
    }

    private static int hugeLength(int oldLength, int minGrowth) {
        int minLength = oldLength + minGrowth;
        if (minLength < 0) {
            throw new OutOfMemoryError("Required array length " + oldLength + " + " + minGrowth + " is too large");
        }
        if (minLength <= 0x7FFFFFF7) {
            return 0x7FFFFFF7;
        }
        return minLength;
    }

    public static int[] toIntArray(List<Integer> ints) {
        if (ints == null) {
            return null;
        }
        int[] array = new int[ints.size()];
        for (int ii = 0; ii < array.length; ++ii) {
            array[ii] = ints.get(ii);
        }
        return array;
    }

    public static byte[] trimToSize(byte[] items, int size) {
        if (size < items.length) {
            items = size == 0 ? EMPTY_BYTE_ELEMENTDATA : Arrays.copyOf(items, size);
        }
        return items;
    }

    public static char getChar(byte[] buffer, int pos) {
        return CHAR_LE_HANDLE.get(buffer, pos);
    }

    public static int getInt(byte[] buffer, int pos) {
        return INT_LE_HANDLE.get(buffer, pos);
    }

    public static void resize(IntArrayList list, int size) {
        list.ensureCapacity(size);
        list.size(size);
    }

    public static void resize(DoubleArrayList list, int size) {
        list.ensureCapacity(size);
        list.size(size);
    }

    public static int binarySearch(IntArrayList list, int value) {
        return IntArrays.binarySearch((int[])list.elements(), (int)0, (int)list.size(), (int)value);
    }

    public static void sort(IntArrayList list) {
        IntArrays.quickSort((int[])list.elements(), (int)0, (int)list.size());
    }

    public static int[] toNativeArray(IntArrayList list, int from, int to) {
        return Arrays.copyOfRange(list.elements(), from, to);
    }
}

