/*
 * Decompiled with CFR 0.152.
 */
package crazydev.common.soap;

import crazydev.common.exception.CdRuntimeException;
import crazydev.common.exception.programming.CdProgrammingException;
import crazydev.common.soap.CdSoapEnvelope;
import jakarta.xml.soap.MessageFactory;
import jakarta.xml.soap.MimeHeaders;
import jakarta.xml.soap.SOAPException;
import jakarta.xml.soap.SOAPFault;
import jakarta.xml.soap.SOAPMessage;
import java.io.ByteArrayInputStream;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XML11Serializer;
import org.jetbrains.annotations.Nullable;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class CdDefaultSoapEnvelope<T>
extends CdSoapEnvelope<T> {
    private static final MessageFactory SOAP_MESSAGE_FACTORY;
    @Nullable
    private final byte[] payload;
    @Nullable
    private final T options;
    private final SOAPMessage message;

    public CdDefaultSoapEnvelope(byte[] payload) throws IOException, SOAPException {
        this(payload, null);
    }

    public CdDefaultSoapEnvelope(byte[] payload, @Nullable T options) throws IOException, SOAPException {
        this.payload = payload;
        this.options = options;
        this.message = SOAP_MESSAGE_FACTORY.createMessage(new MimeHeaders(), (InputStream)new ByteArrayInputStream(payload));
    }

    public CdDefaultSoapEnvelope(InputStream payload) throws IOException, SOAPException {
        this.payload = null;
        this.options = null;
        this.message = SOAP_MESSAGE_FACTORY.createMessage(new MimeHeaders(), payload);
    }

    @Override
    public boolean isFault() throws SOAPException {
        return this.message.getSOAPBody().getFault() != null;
    }

    @Override
    public SOAPFault getFault() throws SOAPException {
        SOAPFault fault = this.message.getSOAPBody().getFault();
        if (fault == null) {
            throw new CdProgrammingException("Missing SOAP fault!");
        }
        return fault;
    }

    @Override
    @Nullable
    public T getOptions() {
        return this.options;
    }

    @Override
    public SOAPMessage getMessage() {
        return this.message;
    }

    @Override
    public String toPrettyPrintString() {
        if (this.payload == null) {
            return "payload-not-available";
        }
        try {
            CharArrayWriter writer = new CharArrayWriter();
            OutputFormat format = new OutputFormat("xml", "UTF-8", true);
            format.setOmitXMLDeclaration(true);
            format.setLineWidth(0);
            XML11Serializer serializer = new XML11Serializer((Writer)writer, format);
            XMLReader saxReader = XMLReaderFactory.createXMLReader();
            saxReader.setContentHandler((ContentHandler)serializer);
            saxReader.parse(new InputSource(new ByteArrayInputStream(this.payload)));
            return writer.toString();
        }
        catch (Exception ex) {
            throw new CdRuntimeException((Throwable)ex, "Pretty print error!");
        }
    }

    public String toString() {
        if (this.payload == null) {
            return super.toString();
        }
        return this.toPrettyPrintString();
    }

    static {
        try {
            SOAP_MESSAGE_FACTORY = MessageFactory.newInstance((String)"SOAP 1.1 Protocol");
        }
        catch (SOAPException ex) {
            throw new CdRuntimeException((Throwable)ex, "SOAP message factory error!");
        }
    }
}

