/*
 * Decompiled with CFR 0.152.
 */
package crazydev.common.security;

import crazydev.common.security.Base64Encoder;
import crazydev.common.security.ICryptoEncoder;
import crazydev.common.utils.CdStringUtils;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Base64;
import javax.crypto.Cipher;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class AESCryptoEncoder
implements ICryptoEncoder {
    public static final char OLD_MARKER = '\u2602';
    private static final SecretKeySpec keyOld;
    private static final SecretKeySpec key;
    private static final IvParameterSpec ivParameterSpec;
    private static final int GCM_IV_LENGTH = 12;
    private static final Cipher cipherOld;
    private final SecureRandom secureRandom = new SecureRandom();

    @Override
    public char getMarker() {
        return '\u2614';
    }

    @Override
    public String encrypt(String plainText) throws SecurityException {
        byte[] encrypted = this.encrypt(plainText.getBytes(StandardCharsets.UTF_8));
        return new String(Base64Encoder.encode(encrypted));
    }

    public byte[] encrypt(byte[] bytes) throws SecurityException {
        Class<AESCryptoEncoder> clazz = AESCryptoEncoder.class;
        synchronized (AESCryptoEncoder.class) {
            try {
                byte[] iv = new byte[12];
                this.secureRandom.nextBytes(iv);
                Cipher cipher = Cipher.getInstance("AES/GCM/NoPadding");
                GCMParameterSpec parameterSpec = new GCMParameterSpec(128, iv);
                cipher.init(1, (Key)key, parameterSpec);
                byte[] cipherText = cipher.doFinal(bytes);
                ByteBuffer byteBuffer = ByteBuffer.allocate(iv.length + cipherText.length);
                byteBuffer.put(iv);
                byteBuffer.put(cipherText);
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return byteBuffer.array();
            }
            catch (Exception e) {
                throw new SecurityException(e.getMessage(), e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String decrypt(String cipherText) throws SecurityException {
        Class<AESCryptoEncoder> clazz = AESCryptoEncoder.class;
        synchronized (AESCryptoEncoder.class) {
            byte[] decryptBytes = this.decrypt(Base64Encoder.decode(cipherText));
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return new String(decryptBytes, StandardCharsets.UTF_8);
        }
    }

    public byte[] decrypt(byte[] cipherBytes) throws SecurityException {
        Class<AESCryptoEncoder> clazz = AESCryptoEncoder.class;
        synchronized (AESCryptoEncoder.class) {
            try {
                Cipher cipher = Cipher.getInstance("AES/GCM/NoPadding");
                GCMParameterSpec gcmIv = new GCMParameterSpec(128, cipherBytes, 0, 12);
                cipher.init(2, (Key)key, gcmIv);
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return cipher.doFinal(cipherBytes, 12, cipherBytes.length - 12);
            }
            catch (Exception e) {
                throw new SecurityException(e.getMessage(), e);
            }
        }
    }

    public String decryptOld(String cipherText) throws SecurityException {
        Class<AESCryptoEncoder> clazz = AESCryptoEncoder.class;
        synchronized (AESCryptoEncoder.class) {
            try {
                byte[] decryptBytes = Base64Encoder.decode(cipherText);
                cipherOld.init(2, (Key)keyOld, ivParameterSpec);
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return new String(cipherOld.doFinal(decryptBytes), StandardCharsets.UTF_8);
            }
            catch (Exception e) {
                throw new SecurityException(e.getMessage(), e);
            }
        }
    }

    public static void assertValidity() {
        new AESCryptoEncoder().encrypt("blabla");
    }

    static {
        try {
            String envKey = System.getenv("ICCUBE_SECRET_KEY");
            byte[] keyBytes = CdStringUtils.isNullOrBlank(envKey) ? new byte[]{-44, -21, 124, -78, -41, 51, -50, -120, -71, 59, 125, 4, 60, 97, -88, -79} : Base64.getDecoder().decode(envKey);
            key = new SecretKeySpec(keyBytes, "AES");
            cipherOld = Cipher.getInstance("AES/CBC/PKCS5Padding");
            keyOld = new SecretKeySpec(new byte[]{-8, -77, -102, 69, -55, 53, -74, 110, -6, -37, 77, -126, 83, 24, -40, 79}, "AES");
            ivParameterSpec = new IvParameterSpec(new byte[]{105, 59, 92, 127, 95, 109, -87, -57, -46, 91, -76, 72, 16, -17, -8, 64});
            cipherOld.init(2, (Key)keyOld, ivParameterSpec);
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | NoSuchPaddingException e) {
            throw new RuntimeException(e);
        }
    }
}

