/*
 * Decompiled with CFR 0.152.
 */
package crazydev.common.request;

import crazydev.common.request.CdGcName;

public class CdGcEvent {
    private final CdGcName name;
    private final String action;
    private final String cause;
    private final long startTimeMS;
    private final long endTimeMS;
    private final long durationMS;

    protected CdGcEvent(CdGcName name, String action, String cause, long startTimeMS, long endTimeMS) {
        this.name = name;
        this.action = action;
        this.cause = cause;
        this.startTimeMS = startTimeMS;
        this.endTimeMS = endTimeMS;
        this.durationMS = endTimeMS - startTimeMS;
    }

    public static CdGcEvent create(String name, String action, String cause, long startTimeMS, long endTimeMS) {
        CdGcName gcName = CdGcName.fromCaption(name);
        return new CdGcEvent(gcName, action, cause, startTimeMS, endTimeMS);
    }

    public boolean isMajor() {
        return this.name.isMajor();
    }

    public CdGcName getName() {
        return this.name;
    }

    public String getAction() {
        return this.action;
    }

    public String getCause() {
        return this.cause;
    }

    public long getStartTimeMS() {
        return this.startTimeMS;
    }

    public long getEndTimeMS() {
        return this.endTimeMS;
    }

    public long getDurationMS() {
        return this.durationMS;
    }

    public String toString() {
        return "[name : " + this.name.getCaption() + "] [action : " + this.action + "] [cause : " + this.cause + "] [start : " + this.startTimeMS + "] [end : " + this.endTimeMS + "] [duration : " + this.durationMS + "] ";
    }
}

