/*
 * Decompiled with CFR 0.152.
 */
package crazydev.common.repository;

import crazydev.common.repository.CdXmlBean;
import crazydev.common.xml.CdXmlUtils;
import jakarta.xml.bind.JAXBException;
import java.io.File;
import java.io.Reader;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public abstract class CdXmlBeanRepository<T extends CdXmlBean> {
    public static final Logger LOGGER = Logger.getLogger((String)"icCube.general");
    protected final String beanFriendlyTypeName;
    protected final Class[] classes;

    public CdXmlBeanRepository(String beanFriendlyTypeName, Class ... classes) {
        this.beanFriendlyTypeName = beanFriendlyTypeName;
        this.classes = classes;
    }

    @Nullable
    public T unmarshallBean(File file, Reader reader, String errInfo) {
        try {
            CdXmlBean bean = (CdXmlBean)CdXmlUtils.unmarshall(file, reader, this.classes);
            return (T)bean;
        }
        catch (JAXBException | RuntimeException ex) {
            this.reportUnmarshallBeanError(errInfo, (Exception)ex);
            return null;
        }
    }

    protected void reportUnmarshallBeanError(@Nullable String errInfo, Exception exception) {
        LOGGER.warn((Object)(this.beanFriendlyTypeName + " file error " + (String)(errInfo == null ? "" : " : " + errInfo)));
        LOGGER.warn((Object)"- error details:", (Throwable)exception);
    }
}

