/*
 * Decompiled with CFR 0.152.
 */
package crazydev.common.property;

import crazydev.common.exception.programming.CdProgrammingException;
import crazydev.common.property.CdProperty;
import crazydev.common.utils.CdClassUtils;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public abstract class CdPropertyHelper {
    public static Map<String, CdProperty> getAllDeclaredProperties(Class<?> beanClass) {
        List<CdProperty> properties = CdPropertyHelper.getAllDeclaredPropertiesAsList(beanClass);
        return properties.stream().collect(Collectors.toMap(CdProperty::getName, p -> p));
    }

    public static List<CdProperty> getAllDeclaredPropertiesAsList(Class<?> beanClass) {
        try {
            HashSet<String> names = new HashSet<String>();
            ArrayList<CdProperty> properties = new ArrayList<CdProperty>();
            Class<?> clazz = beanClass;
            do {
                List<Field> fields = CdClassUtils.getAllDeclaredStaticFields(CdProperty.class, clazz);
                for (Field field : fields) {
                    Object value = field.get(null);
                    CdProperty property = (CdProperty)value;
                    if (names.contains(property.getName())) {
                        throw new CdProgrammingException("Duplicated CdProperty [" + property.getName() + "]!");
                    }
                    names.add(property.getName());
                    properties.add(property);
                }
            } while ((clazz = clazz.getSuperclass()) != Object.class);
            return properties;
        }
        catch (IllegalAccessException ex) {
            throw new CdProgrammingException("CdProperty declaration error!", ex);
        }
    }
}

