/*
 * Decompiled with CFR 0.152.
 */
package crazydev.common.mdx.scanner;

import crazydev.common.mdx.scanner.CdMdxTokenKind;
import crazydev.common.mdx.scanner.CdMdxTokenLocation;

public class CdMdxToken {
    private final CdMdxTokenKind kind;
    private final CdMdxTokenLocation location;
    private final String lexeme;

    public CdMdxToken(CdMdxTokenLocation location, CdMdxTokenKind kind, String lexeme) {
        this.kind = kind;
        this.location = location;
        this.lexeme = lexeme;
    }

    public CdMdxTokenKind getKind() {
        return this.kind;
    }

    public String getMdx() {
        return this.location.mdx();
    }

    public String getMdxHash() {
        return this.location.mdxHash();
    }

    public int getLineNumber() {
        return this.location.lineNumber();
    }

    public int getStartOffset() {
        return this.location.offset();
    }

    public int getEndOffset() {
        return this.location.offset() + this.getLexeme().length();
    }

    public CdMdxTokenLocation getLocation() {
        return this.location;
    }

    public String getLexeme() {
        return this.lexeme;
    }

    public String toString() {
        return this.lexeme;
    }

    public boolean isInvisible() {
        return CdMdxTokenKind.isInvisible(this.kind);
    }
}

