/*
 * Decompiled with CFR 0.152.
 */
package crazydev.common.mdx;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.regex.Pattern;
import org.apache.commons.text.StringEscapeUtils;

public abstract class CdMdxUtils {
    private static final Pattern ESCAPE_PATTERN = Pattern.compile("\\]");

    public static String escape(String name) {
        return ESCAPE_PATTERN.matcher(name).replaceAll("\\]\\]");
    }

    public static String unescapeD(String name) {
        int end;
        StringBuilder sb = new StringBuilder();
        int prev = 0;
        char c0 = name.charAt(0);
        if (c0 == '&' && name.length() > 2 && name.charAt(1) == '[') {
            start = 2;
            end = name.length() - 1;
        } else if (c0 == '[') {
            start = 1;
            end = name.length() - 1;
        } else {
            start = 0;
            end = name.length();
        }
        for (int idx = start; idx < end; ++idx) {
            char cc = name.charAt(idx);
            if (cc == ']' && prev == 93) {
                prev = 0;
                continue;
            }
            sb.append(cc);
            prev = cc;
        }
        return sb.toString();
    }

    public static String escapeForLOG(String statement) {
        try {
            String line;
            StringBuilder sb = new StringBuilder();
            BufferedReader reader = new BufferedReader(new StringReader(statement));
            while ((line = reader.readLine()) != null) {
                sb.append(" ").append(line);
            }
            return sb.toString();
        }
        catch (IOException | RuntimeException ex) {
            return statement;
        }
    }

    public static String escapeForCSV(String statement) {
        if ((statement = StringEscapeUtils.escapeCsv((String)statement)).startsWith("\"")) {
            return statement;
        }
        return "\"" + statement + "\"";
    }
}

