/*
 * Decompiled with CFR 0.152.
 */
package crazydev.common.math;

import crazydev.common.exception.programming.CdShouldNotBeHereProgrammingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.log4j.Logger;

public class CdSortingGraph<Node> {
    public static final Logger BUILDER = Logger.getLogger((String)"icCube.builder");
    private Map<Node, Node> subtitutionMap = new HashMap<Node, Node>();
    private ArrayList<Relation<Node>> parentChildRelations = new ArrayList();

    public void setOneOneRelation(Node parent, Node child) {
        BUILDER.debug((Object)("[graph] one-one [p:" + String.valueOf(parent) + "] [" + String.valueOf(child) + "]"));
        Node newParent = this.subtitutionMap.getOrDefault(parent, parent);
        if (this.subtitutionMap.put(child, newParent) != null) {
            throw new CdShouldNotBeHereProgrammingException(child.toString() + " -> " + parent.toString());
        }
    }

    public void setParentChild(String relationName, Node parent, Node child) {
        BUILDER.debug((Object)("[graph] parent-child [" + relationName + "] [p:" + String.valueOf(parent) + "] [" + String.valueOf(child) + "]"));
        Relation<Node> relationDef = new Relation<Node>(relationName, parent, child);
        this.parentChildRelations.add(relationDef);
    }

    public Map<Node, Integer> solveOrder() throws GraphCycleException {
        if (this.parentChildRelations.isEmpty()) {
            return Collections.emptyMap();
        }
        this.buildSubstitutions();
        HashMap<ChildDef, Set<ChildDef>> childParent = new HashMap<ChildDef, Set<ChildDef>>();
        HashSet allNodes = new HashSet();
        this.parentChildRelations.forEach((Consumer<Relation<Node>>)((Consumer<Relation>)rel -> {
            rel.actualParent = this.subtitutionMap.getOrDefault(rel.parent, rel.parent);
            rel.actualChild = this.subtitutionMap.getOrDefault(rel.child, rel.child);
            ChildDef parent = new ChildDef((Relation)rel, rel.actualParent);
            ChildDef child = new ChildDef((Relation)rel, rel.actualChild);
            childParent.computeIfAbsent(child, node -> new HashSet()).add(parent);
            allNodes.add(parent.node);
            allNodes.add(child.node);
        }));
        HashMap solvedNodes = new HashMap();
        int depth = 0;
        while (this.doSolveOrder(childParent, solvedNodes, depth++)) {
        }
        int leafNodes = depth;
        allNodes.stream().filter(node -> !solvedNodes.containsKey(node)).forEach(node -> solvedNodes.put(node, leafNodes));
        BUILDER.debug((Object)("[graph] solved orders : [ " + solvedNodes.entrySet().stream().map(e -> String.valueOf(e.getKey()) + ":" + String.valueOf(e.getValue())).collect(Collectors.joining(", ")) + " ]"));
        return solvedNodes;
    }

    private void buildSubstitutions() {
        boolean changed;
        if (this.subtitutionMap.size() <= 1) {
            return;
        }
        do {
            changed = false;
            HashSet<Map.Entry<Node, Node>> entries = new HashSet<Map.Entry<Node, Node>>(this.subtitutionMap.entrySet());
            for (Map.Entry<Node, Node> entry : entries) {
                Node substitute = this.subtitutionMap.get(entry.getValue());
                if (substitute == null) continue;
                this.subtitutionMap.put(entry.getKey(), substitute);
                changed = true;
            }
        } while (changed);
    }

    private boolean doSolveOrder(Map<ChildDef, Set<ChildDef>> childParent, Map<Node, Integer> solvedNodes, int depth) throws GraphCycleException {
        Set<Object> roots = this.parentChildRelations.stream().map(rel -> rel.actualParent).filter(actualParent -> !this.containsKey(childParent, actualParent) && !solvedNodes.containsKey(actualParent)).collect(Collectors.toSet());
        if (roots.isEmpty()) {
            return this.reportError(childParent.keySet());
        }
        roots.forEach(root -> solvedNodes.put(root, depth));
        childParent.entrySet().removeIf(child -> this.containsAll(roots, (Set)child.getValue()));
        return !childParent.isEmpty();
    }

    private boolean reportError(Set<ChildDef> childDefs) throws GraphCycleException {
        Set relations = childDefs.stream().map(def -> def.relation).collect(Collectors.toSet());
        String viewsNames = relations.stream().map(rel -> rel.name).collect(Collectors.toSet()).stream().collect(Collectors.joining(", ", "[", "]"));
        String childNames = relations.stream().map(rel -> rel.actualChild.toString() + "->" + rel.actualParent.toString()).collect(Collectors.joining(", ", "[", "]"));
        throw new GraphCycleException("Cycle found in views " + viewsNames + ", cycle found on final nodes " + childNames + ". Hints: Tables are read just once. Some views, e.g. join, fix a relation read table A before B, that might not be possible to solve if they are cycles (e.g. read A before A)");
    }

    private boolean containsAll(Set<Node> roots, Set<ChildDef> children) {
        for (ChildDef child : children) {
            if (roots.contains(child.node)) continue;
            return false;
        }
        return true;
    }

    private boolean containsKey(Map<ChildDef, Set<ChildDef>> childParent, Node lookupNode) {
        for (ChildDef childDef : childParent.keySet()) {
            if (childDef.node != lookupNode) continue;
            return true;
        }
        return false;
    }

    private static class Relation<Node> {
        private final String name;
        private final Node parent;
        private final Node child;
        public Node actualParent;
        public Node actualChild;

        public Relation(String name, Node parent, Node child) {
            this.name = name;
            this.parent = parent;
            this.child = child;
        }
    }

    public static class GraphCycleException
    extends Exception {
        private static final long serialVersionUID = -3290354227600126361L;

        GraphCycleException(String errorMessage) {
            super(errorMessage);
        }
    }

    static class ChildDef<Node> {
        final Relation relation;
        final Node node;

        public ChildDef(Relation relation, Node node) {
            this.relation = relation;
            this.node = node;
        }
    }
}

