/*
 * Decompiled with CFR 0.152.
 */
package crazydev.common.locale;

import crazydev.common.lang.CdAbstractEnum;
import crazydev.common.locale.CdLanguageIdentifierHelper;
import jakarta.xml.bind.annotation.XmlEnum;
import jakarta.xml.bind.annotation.XmlType;
import java.util.Locale;
import org.jetbrains.annotations.Nullable;

@XmlType
@XmlEnum(value=Integer.class)
public enum CdLanguageIdentifier implements CdAbstractEnum
{
    Neutral(0, "Neutral", "Neutral"),
    UserDefault(1024, "UserDefault", "UserDefault"),
    SystemDefault(2048, "SystemDefault", "SystemDefault"),
    Afrikaans_SouthAfrica(1078, "af", "ZA"),
    Albanian_Albania(1052, "sq", "AL"),
    Alsatian_France(1156, "gsw", "FR"),
    Amharic_Ethiopia(1118, "am", "ET"),
    Arabic_Algeria(5121, "ar", "DZ"),
    Arabic_Bahrain(15361, "ar", "BH"),
    Arabic_Egypt(3073, "ar", "EG"),
    Arabic_Iraq(2049, "ar", "IQ"),
    Arabic_Jordan(11265, "ar", "JO"),
    Arabic_Kuwait(13313, "ar", "KW"),
    Arabic_Lebanon(12289, "ar", "LB"),
    Arabic_Libya(4097, "ar", "LY"),
    Arabic_Morocco(6145, "ar", "MA"),
    Arabic_Oman(8193, "ar", "OM"),
    Arabic_Qatar(16385, "ar", "QA"),
    Arabic_SaudiArabia(1025, "ar", "SA"),
    Arabic_Syria(10241, "ar", "SY"),
    Arabic_Tunisia(7169, "ar", "TN"),
    Arabic_UAE(14337, "ar", "AE"),
    Arabic_Yemen(9217, "ar", "YE"),
    Armenian_Armenia(1067, "hy", "AM"),
    Assamese_India(1101, "as", "IN"),
    Azeri_AzerbaijanCyrillic(2092, "az", "AZ"),
    Azeri_AzerbaijanLatin(1068, "az", "AZ"),
    Bashkir_Russia(1133, "ba", "RU"),
    Basque_Basque(1069, "eu", "ES"),
    Belarusian_Belarus(1059, "be", "BY"),
    Bengali_India(1093, "bn", "IN"),
    Bosnian_BosniaandHerzegovinaCyrillic(8218, "bs", "BA"),
    Bosnian_BosniaandHerzegovinaLatin(5146, "bs", "BA"),
    Breton_France(1150, "br", "FR"),
    Bulgarian_Bulgaria(1026, "bg", "BG"),
    Catalan_Spain(1027, "ca", "ES"),
    Chinese_Simplified(4, "zh", "Hans"),
    Chinese_Traditional(31748, "zh", "Hant"),
    Chinese_PRC(2052, "zh", "CN"),
    Chinese_Singapore(4100, "zh", "SG"),
    Chinese_Taiwan(1028, "zh", "TW"),
    Chinese_HongKong_SAR(3076, "zh", "HK"),
    Chinese_Macao_SAR(5124, "zh", "MO"),
    Corsican_France(1155, "co", "FR"),
    Croatian_BosniaandHerzegovinaLatin(4122, "hr", "BA"),
    Croatian_Croatia(1050, "hr", "HR"),
    Czech_CzechRepublic(1029, "cs", "CZ"),
    Danish_Denmark(1030, "da", "DK"),
    Dari_Afghanistan(1164, "prs", "AF"),
    Divehi_Maldives(1125, "dv", "MV"),
    Dutch_Belgium(2067, "nl", "BE"),
    Dutch_Netherlands(1043, "nl", "NL"),
    English_Australia(3081, "en", "AU"),
    English_Belize(10249, "en", "BZ"),
    English_Canada(4105, "en", "CA"),
    English_Caribbean(9225, "en", "029"),
    English_India(16393, "en", "IN"),
    English_Ireland(6153, "en", "IE"),
    English_Jamaica(8201, "en", "JM"),
    English_Malaysia(17417, "en", "MY"),
    English_NewZealand(5129, "en", "NZ"),
    English_Philippines(13321, "en", "PH"),
    English_Singapore(18441, "en", "SG"),
    English_SouthAfrica(7177, "en", "ZA"),
    English_TrinidadandTobago(11273, "en", "TT"),
    English_UnitedKingdom(2057, "en", "GB"),
    English_UnitedStates(1033, "en", "US"),
    English_Zimbabwe(12297, "en", "ZW"),
    Estonian_Estonia(1061, "et", "EE"),
    Faroese_FaroeIslands(1080, "fo", "FO"),
    Filipino_Philippines(1124, "fil", "PH"),
    Finnish_Finland(1035, "fi", "FI"),
    French_Belgium(2060, "fr", "BE"),
    French_Canada(3084, "fr", "CA"),
    French_France(1036, "fr", "FR"),
    French_Luxembourg(5132, "fr", "LU"),
    French_Monaco(6156, "fr", "MC"),
    French_Switzerland(4108, "fr", "CH"),
    Frisian_Netherlands(1122, "fy", "NL"),
    Galician_Spain(1110, "gl", "ES"),
    Georgian_Georgia(1079, "ka", "GE"),
    German_Austria(3079, "de", "AT"),
    German_Germany(1031, "de", "DE"),
    German_Liechtenstein(5127, "de", "LI"),
    German_Luxembourg(4103, "de", "LU"),
    German_Switzerland(2055, "de", "CH"),
    Greek_Greece(1032, "el", "GR"),
    Greenlandic_Greenland(1135, "kl", "GL"),
    Gujarati_India(1095, "gu", "IN"),
    Hausa_Nigeria(1128, "ha", "NG"),
    Hebrew_Israel(1037, "he", "IL"),
    Hindi_India(1081, "hi", "IN"),
    Hungarian_Hungary(1038, "hu", "HU"),
    Icelandic_Iceland(1039, "is", "IS"),
    Igbo_Nigeria(1136, "ig", "NG"),
    Indonesian_Indonesia(1057, "id", "ID"),
    Inuktitut_Canada(2141, "iu", "CA"),
    Inuktitut_Canada_Ex(1117, "iu", "CA"),
    Irish_Ireland(2108, "ga", "IE"),
    isiXhosa_SouthAfrica(1076, "xh", "ZA"),
    isiZulu_SouthAfrica(1077, "zu", "ZA"),
    Italian_Italy(1040, "it", "IT"),
    Italian_Switzerland(2064, "it", "CH"),
    Japanese_Japan(1041, "ja", "JP"),
    Kannada_India(1099, "kn", "IN"),
    Kazakh_Kazakhstan(1087, "kk", "KZ"),
    Khmer_Cambodia(1107, "kh", "KH"),
    Kiche_Guatemala(1158, "qut", "GT"),
    Kinyarwanda_Rwanda(1159, "rw", "RW"),
    Konkani_India(1111, "kok", "IN"),
    Korean_Korea(1042, "ko", "KR"),
    Kyrgyz_Kyrgyzstan(1088, "ky", "KG"),
    Lao_LaoPDR(1108, "lo", "LA"),
    Latvian_Latvia(1062, "lv", "LV"),
    Lithuanian_Lithuanian(1063, "lt", "LT"),
    LowerSorbian_Germany(2094, "dsb", "DE"),
    Luxembourgish_Luxembourg(1134, "lb", "LU"),
    Macedonian_MacedoniaFYROM(1071, "mk", "MK"),
    Malay_BruneiDarassalam(2110, "ms", "BN"),
    Malay_Malaysia(1086, "ms", "MY"),
    Malayalam_India(1100, "ml", "IN"),
    Maltese_Malta(1082, "mt", "MT"),
    Maori_NewZealand(1153, "mi", "NZ"),
    Mapudungun_Chile(1146, "arn", "CL"),
    Marathi_India(1102, "mr", "IN"),
    Mohawk_Canada(1148, "moh", "CA"),
    Mongolian_MongoliaCyrillic(1104, "mn", "MN"),
    Mongolian_MongoliaMong(2128, "mn", "MN"),
    Nepali_Nepal(1121, "ne", "NP"),
    Nepali_India(1121, "ne", "IN"),
    Norwegian_Bokm\u00e5lNorway(1044, "no", "NO"),
    Norwegian_NynorskNorway(2068, "no", "NO"),
    Occitan_France(1154, "oc", "FR"),
    Oriya_India(1096, "or", "IN"),
    Pashto_Afghanistan(1123, "ps", "AF"),
    Persian_Iran(1065, "fa", "IR"),
    Polish_Poland(1045, "pl", "PL"),
    Portuguese_Brazil(1046, "pt", "BR"),
    Portuguese_Portugal(2070, "pt", "PT"),
    Punjabi_India(1094, "pa", "IN"),
    Quechua_Bolivia(1131, "quz", "BO"),
    Quechua_Ecuador(2155, "quz", "EC"),
    Quechua_Peru(3179, "quz", "PE"),
    Romanian_Romania(1048, "ro", "RO"),
    Romansh_Switzerland(1047, "rm", "CH"),
    Russian_Russia(1049, "ru", "RU"),
    Sami_InariFinland(9275, "smn", "FI"),
    Sami_LuleNorway(4155, "smj", "NO"),
    Sami_LuleSweden(5179, "smj", "SE"),
    Sami_NorthernFinland(3131, "se", "FI"),
    Sami_NorthernNorway(1083, "se", "NO"),
    Sami_NorthernSweden(2107, "se", "SE"),
    Sami_SkoltFinland(8251, "sms", "FI"),
    Sami_SouthernNorway(6203, "sma", "NO"),
    Sami_SouthernSweden(7227, "sma", "SE"),
    Sanskrit_India(1103, "sa", "IN"),
    Serbian_BosniaandHerzegovinaCyrillic(7194, "sr", "BA"),
    Serbian_BosniaandHerzegovinaLatin(6170, "sr", "BA"),
    Serbian_Croatia(6170, "sr", "HR"),
    Serbian_SerbiaandMontenegroFormerCyrillic(3098, "sr", "CS"),
    Serbian_SerbiaandMontenegroFormerLatin(2074, "sr", "CS"),
    SesothosaLeboa_SouthAfrica(1132, "nso", "ZA"),
    Setswana_SouthAfrica(1074, "tn", "ZA"),
    Sinhala_SriLanka(1115, "si", "LK"),
    Slovak_Slovakia(1051, "sk", "SK"),
    Slovenian_Slovenia(1060, "sl", "SI"),
    Spanish_Argentina(11274, "es", "AR"),
    Spanish_Bolivia(16394, "es", "BO"),
    Spanish_Chile(13322, "es", "CL"),
    Spanish_Colombia(9226, "es", "CO"),
    Spanish_CostaRica(5130, "es", "CR"),
    Spanish_DominicanRepublic(7178, "es", "DO"),
    Spanish_Ecuador(12298, "es", "EC"),
    Spanish_ElSalvador(17418, "es", "SV"),
    Spanish_Guatemala(4106, "es", "GT"),
    Spanish_Honduras(18442, "es", "HN"),
    Spanish_Mexico(2058, "es", "MX"),
    Spanish_Nicaragua(19466, "es", "NI"),
    Spanish_Panama(6154, "es", "PA"),
    Spanish_Paraguay(15370, "es", "PY"),
    Spanish_Peru(10250, "es", "PE"),
    Spanish_PuertoRico(20490, "es", "PR"),
    Spanish_SpainModernSort(3082, "es", "ES"),
    Spanish_SpainTraditionalSort(1034, "es", "ES"),
    Spanish_UnitedStates(21514, "es", "US"),
    Spanish_Uruguay(14346, "es", "UY"),
    Spanish_Venezuela(8202, "es", "VE"),
    Swahili_Kenya(1089, "sw", "KE"),
    Swedish_Finland(2077, "sv", "FI"),
    Swedish_Sweden(1053, "sv", "SE"),
    Syriac_Syria(1114, "syr", "SY"),
    Tajik_TajikistanCyrillic(1064, "tg", "TJ"),
    Tamazight_AlgeriaLatin(2143, "tzm", "DZ"),
    Tamil_India(1097, "ta", "IN"),
    Tatar_Russia(1092, "tt", "RU"),
    Telugu_India(1098, "te", "IN"),
    Thai_Thailand(1054, "th", "TH"),
    Tibetan_PRC(1105, "bo", "CN"),
    Turkish_Turkey(1055, "tr", "TR"),
    Turkmen_Turkmenistan(1090, "tk", "TM"),
    Ukrainian_Ukraine(1058, "uk", "UA"),
    UpperSorbian_Germany(1070, "hsb", "DE"),
    Urdu_Pakistan(2080, "ur", "PK"),
    Uyghur_PRC(1152, "ug", "CN"),
    Uzbek_UzbekistanCyrillic(2115, "uz", "UZ"),
    Uzbek_UzbekistanLatin(1091, "uz", "UZ"),
    Vietnamese_Vietnam(1066, "vi", "VN"),
    Welsh_UnitedKingdom(1106, "cy", "GB"),
    Wolof_Senegal(1160, "wo", "SN"),
    Yakut_Russia(1157, "sah", "RU"),
    Yi_PRC(1144, "ii", "CN"),
    Yoruba_Nigeria(1130, "yo", "NG");

    private final int position;
    private final String languageCode;
    private final String countryCode;

    private CdLanguageIdentifier(int position, String languageCode, String countryCode) {
        this.position = position;
        this.languageCode = languageCode;
        this.countryCode = countryCode;
    }

    @Nullable
    public static CdLanguageIdentifier fromPosition(int position) {
        CdLanguageIdentifier[] enumValues;
        for (CdLanguageIdentifier enumValue : enumValues = (CdLanguageIdentifier[])CdLanguageIdentifier.class.getEnumConstants()) {
            if (enumValue.getPosition() != position) continue;
            if (CdLanguageIdentifierHelper.isInvalid(enumValue)) {
                return null;
            }
            return enumValue;
        }
        return null;
    }

    @Override
    public int getPosition() {
        return this.position;
    }

    public String getLanguageCode() {
        return this.languageCode;
    }

    public String getCountryCode() {
        return this.countryCode;
    }

    public String toString() {
        return this.name() + " (" + this.position + ")";
    }

    public static void main(String[] args) {
        Locale[] locales;
        for (Locale current : locales = Locale.getAvailableLocales()) {
            for (Locale test : locales) {
                System.out.println(test.getDisplayName(current) + " ");
            }
            System.out.println();
        }
    }
}

