/*
 * Decompiled with CFR 0.152.
 */
package crazydev.common.lang;

import crazydev.common.exception.CdRuntimeException;
import crazydev.common.lang.CdAbstractBitmapEnum;
import crazydev.common.lang.CdAbstractEnum;
import jakarta.xml.bind.annotation.XmlEnum;
import jakarta.xml.bind.annotation.XmlType;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.List;
import org.joda.time.LocalDate;
import org.joda.time.LocalDateTime;

@XmlType
@XmlEnum(value=Integer.class)
public enum CdXmlaSchemaType implements CdAbstractEnum
{
    DBTYPE_EMPTY(0, "empty", "string", new Class[0]),
    DBTYPE_NULL(1, "null", "string", new Class[0]),
    DBTYPE_ERROR(10, "error", "string", new Class[0]),
    DBTYPE_VARIANT(12, "variant", "variant", new Class[0]),
    DBTYPE_R4(4, "float", "float", Float.class, Float.TYPE),
    DBTYPE_R8(5, "double", "double", Double.class, Double.TYPE),
    DBTYPE_DATE(7, "date", "date", Timestamp.class, LocalDateTime.class, LocalDate.class),
    DBTYPE_DBTIMESTAMP(135, "dateTime", "dateTime", Timestamp.class, LocalDateTime.class),
    DBTYPE_HCHAPTER(136, "hchapter", "string", String.class),
    DBTYPE_BOOL(11, "boolean", "boolean", Boolean.class, Boolean.TYPE),
    DBTYPE_WSTR(130, "string", "string", String.class, Integer.TYPE, Integer.class, Enum.class),
    DBTYPE_I1(16, "byte", "byte", Byte.TYPE, Byte.TYPE, Enum.class),
    DBTYPE_I2(2, "short", "short", Short.TYPE, Short.class, Enum.class),
    DBTYPE_I4(3, "int", "int", Integer.TYPE, Integer.class, Enum.class),
    DBTYPE_I8(20, "long", "long", Long.TYPE, Long.class, Enum.class),
    DBTYPE_UI1(17, "unsignedByte", "unsignedByte", Short.TYPE, Short.class, Enum.class),
    DBTYPE_UI2(18, "unsignedShort", "unsignedShort", Integer.TYPE, Integer.class, Enum.class),
    DBTYPE_UI4(19, "unsignedInt", "unsignedInt", Integer.TYPE, Integer.class, Enum.class),
    DBTYPE_UI8(21, "unsignedLong", "unsignedLong", Integer.TYPE, Integer.class, Long.TYPE, Long.class),
    DBTYPE_BYREF(16384, "object", "object", new Class[0]),
    DBTYPE_GUID(72, "uuid", "uuid", String.class),
    DBTYPE_XML(-1, "xmlDocument", "xmlDocument", String.class);

    private final int pos;
    private final String uniqueName;
    private final String serializingName;
    private Class[] javaTypes;

    private CdXmlaSchemaType(int pos, String uniqueName, String serializingName, Class ... javaTypes) {
        this.pos = pos;
        this.uniqueName = uniqueName;
        this.serializingName = serializingName;
        this.javaTypes = javaTypes;
    }

    @Override
    public int getPosition() {
        return this.pos;
    }

    public String getSerializingName() {
        return this.serializingName;
    }

    public boolean isCompatible(Class<?> javaType) {
        if (this == DBTYPE_VARIANT || this == DBTYPE_BYREF) {
            return true;
        }
        if (javaType.isEnum() || CdAbstractBitmapEnum.class.isAssignableFrom(javaType)) {
            javaType = Enum.class;
        }
        if (this == DBTYPE_HCHAPTER && List.class.isAssignableFrom(javaType)) {
            return true;
        }
        return Arrays.asList(this.javaTypes).contains(javaType);
    }

    public boolean isInteger() {
        return this == DBTYPE_I1 || this == DBTYPE_I2 || this == DBTYPE_I4 || this == DBTYPE_I8;
    }

    public boolean isUnsigned() {
        return this == DBTYPE_UI1 || this == DBTYPE_UI2 || this == DBTYPE_UI4 || this == DBTYPE_UI8;
    }

    public boolean isNumeric() {
        return this == DBTYPE_R8 || this.isInteger() || this.isUnsigned();
    }

    public static CdXmlaSchemaType valueOf(String namespace, String value) {
        String xsdTypeWithoutNS = value;
        String[] splits = value.split(":");
        if (splits.length > 1) {
            xsdTypeWithoutNS = splits[1];
            String ns = splits[0];
            if (!ns.equals(namespace)) {
                throw new CdRuntimeException("Namespace name mismatch [requested:" + namespace + "][actual:" + ns + "]");
            }
        }
        for (CdXmlaSchemaType type : CdXmlaSchemaType.values()) {
            if (!type.uniqueName.equals(xsdTypeWithoutNS)) continue;
            return type;
        }
        if ("decimal".equals(xsdTypeWithoutNS)) {
            return DBTYPE_R8;
        }
        throw new CdRuntimeException("Missing XSD type [" + xsdTypeWithoutNS + "] [" + value + "][" + namespace + "]");
    }
}

