/*
 * Decompiled with CFR 0.152.
 */
package crazydev.common.javacompiler;

import crazydev.common.javacompiler.DynamicClassLoader;
import crazydev.common.javacompiler.InMemoryJavaCompiler;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.tools.FileObject;
import javax.tools.ForwardingJavaFileManager;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import org.jetbrains.annotations.Nullable;

class ExtendedStandardJavaFileManager
extends ForwardingJavaFileManager<JavaFileManager> {
    @Nullable
    private final DynamicClassLoader classpath;
    private final List<InMemoryJavaCompiler.CompiledCodeFileObject> compiledCode = new ArrayList<InMemoryJavaCompiler.CompiledCodeFileObject>();

    protected ExtendedStandardJavaFileManager(JavaFileManager fileManager) {
        this(null, fileManager);
    }

    protected ExtendedStandardJavaFileManager(@Nullable DynamicClassLoader classpath, JavaFileManager fileManager) {
        super(fileManager);
        this.classpath = classpath;
    }

    @Override
    public Iterable<JavaFileObject> list(JavaFileManager.Location location, String packageName, Set<JavaFileObject.Kind> kinds, boolean recurse) throws IOException {
        if (this.classpath == null) {
            return super.list(location, packageName, kinds, recurse);
        }
        if (packageName.equals("icCube.nativeFunctions")) {
            Iterable<JavaFileObject> objs = this.classpath.asJavaFileObjects();
            return objs;
        }
        if (packageName.equals("icCube")) {
            Iterable<JavaFileObject> objs = super.list(location, packageName, kinds, recurse);
            return objs;
        }
        return super.list(location, packageName, kinds, recurse);
    }

    @Override
    public String inferBinaryName(JavaFileManager.Location location, JavaFileObject file) {
        if (file instanceof DynamicClassLoader.JavaClassObject) {
            DynamicClassLoader.JavaClassObject co = (DynamicClassLoader.JavaClassObject)file;
            return co.inferBinaryName();
        }
        return super.inferBinaryName(location, file);
    }

    @Override
    public JavaFileObject getJavaFileForInput(JavaFileManager.Location location, String className, JavaFileObject.Kind kind) throws IOException {
        return super.getJavaFileForInput(location, className, kind);
    }

    @Override
    public JavaFileObject getJavaFileForOutput(JavaFileManager.Location location, String className, JavaFileObject.Kind kind, FileObject sibling) {
        try {
            InMemoryJavaCompiler.CompiledCodeFileObject innerClass = new InMemoryJavaCompiler.CompiledCodeFileObject(className);
            this.compiledCode.add(innerClass);
            return innerClass;
        }
        catch (Exception e) {
            throw new RuntimeException("Error while creating in-memory output file for " + className, e);
        }
    }

    public List<InMemoryJavaCompiler.CompiledCodeFileObject> getCompiledCode() {
        return this.compiledCode;
    }
}

