/*
 * Decompiled with CFR 0.152.
 */
package crazydev.common.javacompiler;

import crazydev.common.javacompiler.CompiledClass;
import crazydev.common.javacompiler.CompiledCode;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.tools.JavaFileObject;
import javax.tools.SimpleJavaFileObject;
import org.jetbrains.annotations.Nullable;

public class DynamicClassLoader
extends ClassLoader {
    public static final int ID_NATIVE_FUNCTIONS = 0;
    public static final int ID_VIEWS = 1;
    private final int securityProfileId;
    private final Map<String, CompiledClass> classes = new HashMap<String, CompiledClass>();

    public DynamicClassLoader(ClassLoader parent, int securityProfileId) {
        super(parent);
        this.securityProfileId = securityProfileId;
    }

    public int getSecurityProfileId() {
        return this.securityProfileId;
    }

    public void addCode(CompiledCode cc) {
        List<CompiledClass> classes = cc.getClasses();
        if (classes != null) {
            for (CompiledClass clazz : classes) {
                this.classes.put(clazz.getClassName(), clazz);
            }
        }
    }

    public boolean hasClass(String classname) {
        return this.classes.get(classname) != null;
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        CompiledClass clazz = this.classes.get(name);
        if (clazz == null) {
            return super.findClass(name);
        }
        byte[] byteCode = clazz.getByteCode();
        return this.defineClass(name, byteCode, 0, byteCode.length);
    }

    @Nullable
    public byte[] getByteCode(Class<?> clazz) {
        CompiledClass cClass = this.classes.get(clazz.getName());
        return cClass != null ? cClass.getByteCode() : null;
    }

    public Iterable<JavaFileObject> asJavaFileObjects() {
        ArrayList<JavaFileObject> objs = new ArrayList<JavaFileObject>();
        this.classes.forEach((classname, clazz) -> objs.add(new JavaClassObject((CompiledClass)clazz)));
        return objs;
    }

    public DynamicClassLoader dropCode(String classname) {
        if (this.classes.get(classname) == null) {
            return this;
        }
        DynamicClassLoader cl = new DynamicClassLoader(this.getParent(), this.securityProfileId);
        cl.classes.putAll(this.classes);
        cl.classes.remove(classname);
        return cl;
    }

    static class JavaClassObject
    extends SimpleJavaFileObject {
        private final ByteArrayInputStream in;
        private final String bn;

        protected JavaClassObject(CompiledClass clazz) {
            super(URI.create("file:///" + clazz.getClassName().replace('.', '/') + JavaFileObject.Kind.CLASS.extension), JavaFileObject.Kind.CLASS);
            this.in = new ByteArrayInputStream(clazz.getByteCode());
            this.bn = clazz.getClassName();
        }

        public String inferBinaryName() {
            return this.bn;
        }

        @Override
        public InputStream openInputStream() throws IOException {
            return this.in;
        }

        @Override
        public OutputStream openOutputStream() throws IOException {
            throw new RuntimeException("ouch!");
        }

        @Override
        public Writer openWriter() throws IOException {
            throw new RuntimeException("ouch!");
        }
    }
}

