/*
 * Decompiled with CFR 0.152.
 */
package crazydev.common.javacompiler;

import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import javax.tools.Diagnostic;
import javax.tools.JavaFileObject;

public class CompilationException
extends Exception {
    private static final long serialVersionUID = 5272588827551900536L;
    private final List<Error> errors;

    public CompilationException(List<Error> errors) {
        super(CompilationException.asMessage(errors));
        this.errors = errors;
    }

    private static String asMessage(List<Error> errors) {
        return errors.stream().map(error -> "Error at line " + error.lineNumber + " : " + error.errorMessage).collect(Collectors.joining("\n"));
    }

    public List<Error> getErrors() {
        return this.errors;
    }

    public static class Error {
        private final Diagnostic.Kind kind;
        private final int lineNumber;
        private final int startPosition;
        private final int endPosition;
        private final String errorMessage;

        public Error(Diagnostic<? extends JavaFileObject> d) {
            this.kind = d.getKind();
            this.lineNumber = (int)d.getLineNumber();
            this.startPosition = (int)d.getStartPosition();
            this.endPosition = (int)d.getEndPosition();
            this.errorMessage = d.getMessage(Locale.US);
        }

        public Diagnostic.Kind getKind() {
            return this.kind;
        }

        public int getLineNumber() {
            return this.lineNumber;
        }

        public int getStartPosition() {
            return this.startPosition;
        }

        public int getEndPosition() {
            return this.endPosition;
        }

        public String getErrorMessage() {
            return this.errorMessage;
        }
    }
}

